﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Vektoren
{
    public partial class Form1 : Form
    {
        List<vec> vectors;

        public Form1()
        {
            InitializeComponent();
            vectors = new List<vec>();
        }

        //Hier wird der Vektor erstellt
        private void button1_Click(object sender, EventArgs e)
        {
            int length = (int)numericUpDown1.Value;
            vec v = new vec(length);
            AddVector(v);
        }

        private void AddVector(vec v)
        {
            vectors.Add(v);
            listBox1.Items.Add(v);
        }

        private void button3_Click(object sender, EventArgs e)
        {
            foreach (vec v in vectors)
                v.Randomize();

            listBox1.Items.Clear();

            foreach (vec v in vectors)
                listBox1.Items.Add(v);
        }

        private void button2_Click(object sender, EventArgs e)
        {
            if(vectors.Count == 0)
                throw new Exception("Diese Methode steht nur zur Verfügung wenn bereits Vektoren hinzugefügt worden sind.");

            vec v = vectors[0];

            for(int i = 1; i < vectors.Count; i++)
                v = v + vectors[i];

            AddVector(v);
        }

        private void listBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            button5.Enabled = listBox1.SelectedItem != null;
        }

        private void button4_Click(object sender, EventArgs e)
        {
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
                AddVector(new vec(openFileDialog1.FileName));
        }

        private void button5_Click(object sender, EventArgs e)
        {
            if (saveFileDialog1.ShowDialog() == DialogResult.OK)
            {
                if ((listBox1.SelectedItem as vec).Save(saveFileDialog1.FileName))
                    MessageBox.Show("Speichern erfolgreich!");
                else
                    MessageBox.Show("Speichern fehlgeschlagen...");
            }
        }
    }
}
