﻿using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.DirectX.DirectSound;
using System.IO;

namespace Chat_Programm
{

    class AudioGet
    {
        private Device device1;
        private SecondaryBuffer[] soundbuffers;
        private Stream stream1;
        DevicesCollection devList;

        public event EventHandler<ReportStateEventArgs> ReportState;

        public Stream Stream1
        {
            get { return stream1; }
            set { stream1 = value; }
        }

        public SecondaryBuffer[] Soundbuffers
        {
            get { return soundbuffers; }
            set { soundbuffers = value; }
        }

        public Device Device1
        {
            get { return device1; }
            set { device1 = value; }
        }

        public AudioGet(IntPtr parent, int index)
        {
            devList = new DevicesCollection();
            Device1 = new Device(devList[index].DriverGuid);
            Device1.SetCooperativeLevel(parent, CooperativeLevel.Priority);

            //Description für Eigenschaften der Aufnahme
            var capDesc = new BufferDescription();

            capDesc.Format = Audioproperties.Format;
            capDesc.BufferBytes = Convert.ToInt32(Audioproperties.OutputBufferSize);
            
            soundbuffers = new SecondaryBuffer[2];
            try
            {
                soundbuffers[0] = new SecondaryBuffer(capDesc, Device1);
                soundbuffers[1] = new SecondaryBuffer(capDesc, Device1);
            }
            catch (Exception ex)
            {
                ReportState(this, new ReportStateEventArgs(ex.Message));
            }


        }


    }
}
