﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Net.Sockets;
using System.IO;
using System.Windows.Forms;

namespace Chat_Programm
{
    class Empfangen_Senden // in dieseer Klasse haben wir die Methoden Empfangen und Send weil wir sowohl als client als auch als Server auf diese funktionen zu greifen muessen
    {
        byte[] buffer;
        byte[] message;

        TcpClient tcpclient1;

       
        public event EventHandler<ReportStateEventArgs> ReportState;
        public event EventHandler<MessageReceivedEventArgs> MessageReceived;

        public byte[] Buffer
        {
            get { return buffer; }
            set { buffer = value; }
        }
        public byte[] Message
        {
            get { return message; }
            set { message = value; }
        }
        public TcpClient Tcpclient1
        {
            get { return tcpclient1; }
            set { tcpclient1 = value; }
        }

        public void Send(string str )
        {
            try
            {
                Stream messageStream = Tcpclient1.GetStream();

                //Stream befüllen
                //Die Eingabe wird in Bytes verwandelt, die Länge wird gelesen
                //der Stream überträgt mit den ersten 4 Bytes die Länge des Buffers, 
                //danach folgen die Bytes die den Buffer selbst beschreiben
                ASCIIEncoding encode = new ASCIIEncoding();
                Buffer = encode.GetBytes(str);

                using (MemoryStream ms = new MemoryStream())
                {
                    ms.Write(BitConverter.GetBytes(Buffer.Length), 0, 4);
                    ms.Write(buffer, 0, Buffer.Length);
                    Buffer = ms.ToArray();
                }

                IAsyncResult iar = messageStream.BeginWrite(Buffer, 0, Buffer.Length, new AsyncCallback(SendDataComplete), 0);
            }

            catch (Exception ex)
            {
                string temp = ex.Message;
                ReportState(this, new ReportStateEventArgs(temp));
            }
        }
        private void SendDataComplete(IAsyncResult e)
        {
           // MessageBox.Show("Mitteilung übertragen!");
        }

        public void empfangen()
        {
            Message = new byte[4096]; // wir koennen maximal 4kb empfangen
           
            try
            {
                NetworkStream msg = this.Tcpclient1.GetStream();                 
                IAsyncResult z = msg.BeginRead(Message, 0, Message.Length, new AsyncCallback(RecieverDataComplete), 0);
            }
            catch(Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void RecieverDataComplete(IAsyncResult e)
        {

            NetworkStream s = e.AsyncState as NetworkStream;

            byte[] tmpmsg = new byte[4]; // in den ersten 4 bytes steht die laenge der gesendeten Nachricht

            for (int i = 0; i < tmpmsg.Length; i++)
                tmpmsg[i] = message[i];

            int length = BitConverter.ToInt32(message, 0); //nun wissen wir die laenge der nachricht

            tmpmsg = new byte[length];

            for (int i = 0; i < tmpmsg.Length; i++) // und koennen diese dann auslesen, und muessen nicht ueber die nachricht hinaus die 4 kb "lesen"
                tmpmsg[i] = message[i + 4];

            ASCIIEncoding encoder = new ASCIIEncoding(); 
            if(MessageReceived != null)
                MessageReceived(this, new MessageReceivedEventArgs(encoder.GetString(tmpmsg, 0, length)));
            // wirft das Event MessageReceived, welches dann Die nachricht in die Listbox ausgibt
            //dafuer muessen wir aber dies von byte in string convertieren

            empfangen(); // erneuter aufruf, damit wir nicht aufhoeren zu testen ob wir eine nachricht bekommen haben
        }


    }
}
