﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using Microsoft.DirectX.DirectSound;
using System.Net.Sockets;
using System.Windows.Forms;

namespace Chat_Programm
{
    class TalkListen : Form
    {
        public event EventHandler<ReportStateEventArgs> ReportState;
        AudioSet sprecher;
        AudioGet zuhoerer;
        TcpClient client1;
        byte[] message;
        int aktueller_devbuffer = 0;

        public int Aktueller_devbuffer
        {
            get { return aktueller_devbuffer; }
            set { aktueller_devbuffer = value; }
        }

        internal AudioGet Zuhoerer
        {
            get { return zuhoerer; }
            set { zuhoerer = value; }
        }

        internal AudioSet Sprecher
        {
            get { return sprecher; }
            set { sprecher = value; }
        }

        public TcpClient Client1
        {
            get { return client1; }
            set { client1 = value; }
        }

        public byte[] Message
        {
            get { return message; }
            set { message = value; }
        }

        public void Dialogue(object o)
        {
            try
            {
                object[] obj = o as object[];
                IntPtr handle = (IntPtr)obj[0];
                int mic = (int)obj[1];
                int speaker = (int)obj[2];
                Client1 = obj[3] as TcpClient;

                Zuhoerer = new AudioGet(handle, speaker);
                Sprecher = new AudioSet(mic);

                //Stream wird auf den TcpClient gelegt
                NetworkStream msg = Client1.GetStream();

                var resetEvent = new AutoResetEvent(false);
                
                var notify = new Notify(Sprecher.Capbuffer);
               
                var bpn1 = new BufferPositionNotify();
                
                bpn1.Offset = Sprecher.Capbuffer.Caps.BufferBytes / 2 - 1;
                bpn1.EventNotifyHandle = resetEvent.SafeWaitHandle.DangerousGetHandle();

                var bpn2 = new BufferPositionNotify();
                bpn2.Offset = Sprecher.Capbuffer.Caps.BufferBytes - 1;
                bpn2.EventNotifyHandle = resetEvent.SafeWaitHandle.DangerousGetHandle();

                notify.SetNotificationPositions(new BufferPositionNotify[] { bpn1, bpn2 });

                bool IsReady = true; // Sound wird aufgenommen
                int offset = 0;

                // Thread starten
                var capturethread = new Thread((ThreadStart)delegate
                {
                    Sprecher.Capbuffer.Start(true); // start capture

                    // Während Aufnahme true
                    while (IsReady)
                    {
                        resetEvent.WaitOne();

                        //Ausgehenden Sound in Netzwerkarray buffern:
                        //den inhalt aus dem capbuffer in ein array lesen und in ein byte array casten
                        var read = Sprecher.Capbuffer.Read(offset, typeof(byte), LockFlag.None, Convert.ToInt32(Audioproperties.OutputBufferSize)) as byte[];

                        NetworkStream sendpackage = Client1.GetStream();
                        //Stream in Netzwerkstream schreiben
                        IAsyncResult q = sendpackage.BeginWrite(read, 0, read.Length, new AsyncCallback(SoundPackageSent), 0);

                        //Eingehenden Netzwerkstream in ein Array lesen und in den aktuellen devBuffer schreiben
                        //Die Message hat die Länge die in den Properties festgelegt wurde
                         Message = new byte[Convert.ToInt32(Audioproperties.OutputBufferSize)];
                        NetworkStream getpackage = Client1.GetStream();
                        IAsyncResult z = getpackage.BeginRead(Message, 0, Message.Length, new AsyncCallback(SoundPackageReceived), 0);

                        // Update offset
                        offset = (offset + Convert.ToInt32(Audioproperties.OutputBufferSize)) % Convert.ToInt32(Audioproperties.CaptureBufferSize);
                    }
                    //Capture Stoppen
                    Sprecher.Capbuffer.Stop();

                });
                //neuen Thread starten
                capturethread.Start();
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
                //ReportState(this, new ReportStateEventArgs(ex.Message));
            }
        }

        private void SoundPackageReceived(IAsyncResult e)
        {

           // NetworkStream s = e.AsyncState as NetworkStream;
            //Nach erfolgreichem Empfang wird die "Message" in den aktuellen soundbuffer geschrieben..
            Zuhoerer.Soundbuffers[Aktueller_devbuffer].Write(0, Message, LockFlag.EntireBuffer);

            //..aaand -----wait for it--- finally it's playtime ;)
            Zuhoerer.Soundbuffers[Aktueller_devbuffer].SetCurrentPosition(0);
            Zuhoerer.Soundbuffers[Aktueller_devbuffer].Play(0, BufferPlayFlags.Default);
            //Nun noch den aktuellen Buffer wechseln
            Aktueller_devbuffer = 1 - Aktueller_devbuffer;
            // wir bleiben in der while schleife..

        }

        private void SoundPackageSent(IAsyncResult e)
        {
            //Hier könnte man nach jedem gesendeten AudioPackage etwas ausführen.
            //oder anderweitig spaß haben :)
        }

    }

}







