﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Net.Sockets;
using System.Net;
using System.IO;
using System.Threading;
using System.Net.NetworkInformation;
namespace Chat_Programm
{
    class Client
    {
        private IPAddress ipadresse;
        private int port;
        private TcpClient tcpclient1;
        public event EventHandler<ReportStateEventArgs> ReportState;
        public event EventHandler<ConnectEventArg> Connect;
        byte[] message;

        public byte[] Message
        {
            get { return message; }
            set { message = value; }
        }

        public TcpClient Tcpclient1
        {
            get { return tcpclient1; }
            set { tcpclient1 = value; }
        }

        public Client(IPAddress ipadresse, int port)
        {
            this.ipadresse = ipadresse;
            this.port = port;

        }

        public Client(IPAddress ipadressefinal)
        {

            this.ipadresse = ipadressefinal;
        }


        public void OnConnet()
        {
            MessageBox.Show("Connect erfolgreich!");
        }

        public void connecten()
        {
           
            try
            {

                //Mit Server auf Port 1000 verbinden
                Tcpclient1 = new TcpClient();
                Tcpclient1.Connect(this.ipadresse, this.port);
                //  MessageBox.Show("Client erstellt!");
                string temp = Tcpclient1.Connected.ToString();
                // MessageBox.Show((Tcpclient1.Connected.ToString()));
                ReportState(this, new ReportStateEventArgs("Connected.."));
                Connect(this, new ConnectEventArg(Tcpclient1));
                
              }

            catch (Exception ex)
            {
                string temp = ex.Message;
                ReportState(this, new ReportStateEventArgs(temp));
            }
        }

       

       

        public string close()
        {
            this.tcpclient1.Close();
            return tcpclient1.Connected.ToString();
        }

        public string Pinger()
        {
            string result;
            try
            {
                // Ping erstellen 
                Ping test = new Ping();

                PingReply reply = test.Send(this.ipadresse, 2000);
                result = reply.Status.ToString();

                if (reply.Status == IPStatus.Success)
                {
                    // erfolgreich
                    result += " Antwort in {0}ms erhalten" + reply.RoundtripTime;
                }
                else if (reply.Status == IPStatus.TimedOut)
                {
                    // keine Antwort innerhalb <timeout> ms
                    result += " Timeout";
                }

                return result;

            }//            
            catch (Exception ex)
            {
                return "huhu" + ex.Message;
            }
        }

       
    }

    
}
