﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Data;

namespace iSkript
{
    public class CSVReader
    {
        public static string[][] Read(string fileName)
        {
            string[] lines = null;

            using (StreamReader sr = new StreamReader(fileName, Encoding.Default))
            {
                lines = sr.ReadToEnd().Split(new string[] { Environment.NewLine }, StringSplitOptions.RemoveEmptyEntries);
            }

            string[][] table = new string[lines.Length][];

            for (int i = 0; i < lines.Length; i++)
                table[i] = lines[i].Split(';');

            return table;
        }


        public static DataTable ErzeugeTabelle(string[][] array) 
        {
            DataTable Lagerbestand = new DataTable("Lagerbestand");

            DataColumn column = new DataColumn();
            column.DataType = System.Type.GetType("System.String");
            column.AllowDBNull = false;
            column.Caption = "Name";
            column.ColumnName = "Name";
            column.DefaultValue = "Ohne Namen";
            

            DataColumn column2 = new DataColumn();
            column2.DataType = System.Type.GetType("System.Int32");
            column2.AllowDBNull = false;
            column2.Caption = "Anzahl pro Karton";
            column2.ColumnName = "Anzahl pro Karton";
            column2.DefaultValue = 0;

            DataColumn column3 = new DataColumn();
            column3.DataType = System.Type.GetType("System.Int32");
            column3.AllowDBNull = false;
            column3.Caption = "Anzahl Kartons";
            column3.ColumnName = "Anzahl Kartons";
            column3.DefaultValue = 0;

            DataColumn column4 = new DataColumn();
            column4.DataType = System.Type.GetType("System.Int32");
            column4.AllowDBNull = false;
            column4.Caption = "Anzahl Infostand";
            column4.ColumnName = "Anzahl Infostand";
            column4.DefaultValue = 0;
           
            DataColumn column5 = new DataColumn();
            column5.DataType = System.Type.GetType("System.Int32");
            column5.AllowDBNull = false;
            column5.Caption = "Gesamtbestand (Stück)";
            column5.ColumnName = "Gesamtbestand (Stück)";
            column5.DefaultValue = 0.00M;

            DataColumn column6 = new DataColumn();
            column6.DataType = System.Type.GetType("System.Decimal");
            column6.AllowDBNull = false;
            column6.Caption = "Preis";
            column6.ColumnName = "Preis";
            column6.DefaultValue = 0;



            Lagerbestand.Columns.Add(column);
            Lagerbestand.Columns.Add(column2);
            Lagerbestand.Columns.Add(column3);
            Lagerbestand.Columns.Add(column4);
            Lagerbestand.Columns.Add(column5);
            Lagerbestand.Columns.Add(column6);

            return Lagerbestand;

        }
    }
}
