﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Windows.Forms;
using System.IO;

namespace iSkript
{
    static class Program
    {
        /// <summary>
        /// Der Haupteinstiegspunkt für die Anwendung.
        /// </summary>
        [STAThread]
        static void Main()
        {
            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);
            string projectPath = Environment.CurrentDirectory + "\\Lagerbestand.xml";

            if (!File.Exists(projectPath))
            {
                OpenFileDialog ofd = new OpenFileDialog();
                ofd.Filter = "XML-Dateien|*.xml";
                ofd.InitialDirectory = Environment.CurrentDirectory;
                ofd.Multiselect = false;
                ofd.Title = "Lagerbestands-Datenbank auswählen";
                ofd.CheckPathExists = true;

                if (ofd.ShowDialog() == DialogResult.OK)
                    projectPath = ofd.FileName;
                else
                    return;
            }

            Application.Run(new Hauptfenster(projectPath));
        }
    }
}
