﻿using System.Collections.Generic;

namespace ProjectKraehwinkel
{
    //nur ca. 20 repräsentative Bürger, die Stadt besitzen
    class Buerger
    {
        public string name;
        public int Vermoegen;
        public List<Fabrik> Besitz;

        protected Buerger()
        {
        }

        public Buerger(string name, int vermoegen)
        {
            this.name = name;
            this.Vermoegen = vermoegen;
            Besitz = new List<Fabrik>();
        }
        
        public virtual void Rundebeenden(Markt markt)
        {
            foreach (Fabrik haus in Besitz)
            {
                int temp = markt.WarenVomMarktKaufen(haus.Verbraucht, 20);

                if(Vermoegen > temp)
                {
                   Vermoegen = Vermoegen - temp + markt.AnMarktVerkaufen(haus.Produziert, haus.Rundebeenden(20));
                }
            }
        }
            
            //Geht jedes Item in List durch und beendet Runde      
    }

    class Player : Buerger
    {
        public int[] Lager;
       
        public Player()
        {
            name = "Du";
            Lager = new int[(int)Waren.Anzahl];
            Vermoegen = 22000;
            Besitz = new List<Fabrik>();
            for (int i = 0; i < Lager.Length; i++)
            {
                Lager[i] = 0;
            }
        }

        public void Bauen(Fabrik fabrik)
        {
            Besitz.Add(fabrik);
        }
        
        public override void Rundebeenden(Markt markt)
        {
            foreach (Fabrik Haus in Besitz)
            {                
               Lager[(int)Haus.Produziert] += Haus.Rundebeenden(Lager[(int)Haus.Verbraucht]);
               if (Lager[(int)Haus.Verbraucht] > 20)
               {
                   Lager[(int)Haus.Verbraucht] -= 20;
               }
               else
                   Lager[(int)Haus.Verbraucht] = 0;
            }
        }
    }
}
