﻿using System.Drawing;
using SdlDotNet.Graphics;

namespace ProjectKraehwinkel
{
    enum Gebaeudearten
    {
        //Hier folgen die Fabrikarten
        Saegewerk,
        Eisenschelze,
        Schnapsbrennerei,
        Bauernhof
    }
   
    //Abstrakte Gebäudeklasse, auf die Spielfeld zugreift.
    abstract class Gebaeude
    {
        public int bewohner;
        protected Point lage;
        public MenueAnzeige Menuetyp;

        //Es wird immer der Geldbetrag zurückgegeben, der sich geändert hat

        public abstract int Rundebeenden(int Anzahl);
    }

    class Wohnung: Gebaeude
    {

        public Wohnung(Point pos, int bewohner, Spielfeld spielfeld)
        {
            lage = pos;
            this.bewohner = bewohner;
            spielfeld.karte[lage.X, lage.Y] = new Tile(new Surface(grafic.Wohnung),this);
            Menuetyp = MenueAnzeige.Wohnung;
        }

        //Beispiel einer Methode die im zug aufgerufen wird
        public int MieteEntrichten()
        {
            return bewohner * (int)Konstanten.Miete;
        }

        public override int Rundebeenden(int Anzahl)
        {
           return MieteEntrichten();
        }
    }

    class Fabrik: Gebaeude
    {
        public Waren Produziert;
        public Waren Verbraucht;

        public Buerger Besitzer;
        public Gebaeudearten gebaedeart;

        public Fabrik(Point pos, Gebaeudearten Gebaeudeart, Spielfeld spielfeld, Buerger besitzer)
        {
            lage = pos;
            Menuetyp = MenueAnzeige.Fabrik;
            Besitzer = besitzer;
            gebaedeart = Gebaeudeart;

            switch (Gebaeudeart)
            {
                case Gebaeudearten.Saegewerk:
                    {
                        Produziert = Waren.Bretter;
                        Verbraucht = Waren.Holz;
                        spielfeld.karte[lage.X, lage.Y] = new Tile(new Surface(grafic.Saegewerk),this);
                        break;
                    }

                case Gebaeudearten.Bauernhof:
                    {
                        Produziert = Waren.Nahrung;
                        Verbraucht = Waren.Schnaps;
                        spielfeld.karte[lage.X, lage.Y] = new Tile(new Surface(grafic.Bauernhof),this);
                        break;
                    }

                case Gebaeudearten.Eisenschelze:
                    {
                        Produziert = Waren.Eisen;
                        Verbraucht = Waren.Erz;
                        spielfeld.karte[lage.X, lage.Y] = new Tile(new Surface(grafic.Eisenschmelze),this);

                        break;
                    }

                case Gebaeudearten.Schnapsbrennerei:
                    {
                        Produziert = Waren.Schnaps;
                        Verbraucht = Waren.Nahrung;
                        spielfeld.karte[lage.X, lage.Y] = new Tile(new Surface(grafic.Schmapsbrennerei),this);
                        break;
                    }
            }
        }

        public override int Rundebeenden(int Anzahl)
        {
            if (Anzahl > 20)
            {
                return 20;
            }
            else
            return Anzahl;
        }
    }

    class Kirche : Gebaeude
    {
        public Kirche()
        {      
           Menuetyp = MenueAnzeige.Kirche;
        }
        public override int Rundebeenden(int Anzahl)
        {
            return 0;
        }
    }

    class Marktbuilding : Gebaeude
    {
        public Marktbuilding()
        {
            Menuetyp = MenueAnzeige.Markt;
        }
        public override int Rundebeenden(int Anzahl)
        {
            return 0;
        }
    }

    class Bauplatz : Gebaeude
    {
        public override int Rundebeenden(int Anzahl)
        {
            return 0;
        }
    }
}
