﻿using System;
using System.Drawing;
using SdlDotNet.Graphics;

namespace ProjectKraehwinkel
{
    class MenueSpieler
    {
        public Size MenueSize;
        SdlDotNet.Graphics.Font font;
        Stadt stadt;
        Spielfeld spielfeld;

        public MenueSpieler(Size menueSize,Stadt stadt, Spielfeld spielfeld)
        {
            MenueSize = menueSize;
            font = new SdlDotNet.Graphics.Font(grafic.arial, 12);
            this.stadt = stadt;
            this.spielfeld = spielfeld;
        }

        public Surface draw()
        {
            Surface MenueSur = new Surface(MenueSize);
            MenueSur.Fill(Color.Red);

            Surface Text = font.Render("Vermögen: " + spielfeld.stadt.spieler.Vermoegen, Color.Black);
            MenueSur.Blit(Text, new Point(10, 5));

            for (int i = 0; i < stadt.markt.Lager.Length; i++)
            {
                Text = font.Render((Enum.GetNames(typeof(Waren))[i] + ":" + spielfeld.stadt.spieler.Lager[i]), Color.Black);
                MenueSur.Blit(Text, new Point(10, 15 * i + 25));

                Text = new Surface(60, 15);
                Text.Fill(Color.Yellow);
                MenueSur.Blit(Text, new Point(80, 15 * i + 25));

                Text = font.Render("kaufen" , Color.Black);
                MenueSur.Blit(Text, new Point(90, 15 * i + 25));

                Text = new Surface(60, 15);
                Text.Fill(Color.Orange);
                MenueSur.Blit(Text, new Point(140, 15 * i + 25));

                Text = font.Render("verkaufen", Color.Black);
                MenueSur.Blit(Text, new Point(145, 15 * i + 25));

            }

            return MenueSur;
        }

        public void Clicked(int x, int y)
        {
            if (y < 115 && y > 25)
            {
                y -= 25;
                y = y / 15;

                if (x > 80 && x < 140)
                {
                    int temp = stadt.markt.WarenVomMarktKaufen((Waren)y, 10);
                    if (stadt.spieler.Vermoegen >= temp && temp < 0)
                    {
                        stadt.spieler.Vermoegen += temp;
                        stadt.spieler.Lager[y] += 10;
                    }
                }

                if (x > 140 && x < 200)
                {
                    if (stadt.spieler.Lager[y] >= 10)
                    {
                        stadt.spieler.Vermoegen += stadt.markt.AnMarktVerkaufen((Waren)y, 10);
                        stadt.spieler.Lager[y] -= 10;
                    }
                }
            }
        }


    }
}
