﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Minen
{
    [Serializable]
    public class Highscores
    {
        int[] anf;

        public int[] Anf
        {
            get { return anf; }
            set { anf = value; }
        }

        int[] mittel;

        public int[] Mittel
        {
            get { return mittel; }
            set { mittel = value; }
        }

        int[] profi;

        public int[] Profi
        {
            get { return profi; }
            set { profi = value; }
        }

        int[] userdefined;

        public int[] Userdefined
        {
            get { return userdefined; }
            set { userdefined = value; }
        }

        /// <summary>
        /// Defaultkonstruktor für Serialisierung
        /// </summary>
        public Highscores() { }

        /// <summary>
        /// erzeugt Standardhighscores (sonst Probleme wenn keine geladen werden können)
        /// </summary>
        public void DefaultScores()
        {
            //Muster: 0=1.Platz - 2=3.Platz, 3=gewonnene Spiele, 4=gesamte Spiele 
            anf=new int[5]{999, 999, 999, 0, 0};
            mittel = new int[5] { 999, 999, 999, 0, 0 };
            profi = new int[5] { 999, 999, 999, 0, 0 };
            //Muster: 0=gewonnene, 1=gesamte Spiele
            userdefined = new int[2] { 0, 0};
        }

        /// <summary>
        /// bei Spielende Zähler für Statistik erhöhen
        /// frägt ab, zu welchen Einstellungen das Spiel passt
        /// </summary>
        /// <param name="gd"></param>
        /// <param name="mines"></param>
        /// <param name="win"></param>
        public void AddWin(GameData gd, Minensucher mines, bool win)
        {
            if (gd.Equals(mines.Standardeinstellungen[0]))
            {
                if (win) anf[3]++;
                anf[4]++;
            }
            else if (gd.Equals(mines.Standardeinstellungen[1]))
            {
                if (win) mittel[3]++;
                mittel[4]++;
            }
            else if (gd.Equals(mines.Standardeinstellungen[1]))
            {
                if (win) profi[3]++;
                profi[4]++;
            }
            else
            {
                if (win) userdefined[0]++;
                userdefined[1]++;
            }
        }

        
        /// <summary>
        /// neuen Highscore schreiben(Rückgabewert=Platz, 0=kein neuer Highscore)
        /// benutzerdefiniert wird ignoriert
        /// </summary>
        /// <param name="gd"></param>
        /// <param name="mines"></param>
        /// <param name="time"></param>
        /// <returns></returns>
        public int NewScore(GameData gd, Minensucher mines, int time)
        {
            if (gd.Equals(mines.Standardeinstellungen[0]))
            {
                if (time < anf[0])
                {
                    anf[2] = anf[1];
                    anf[1] = anf[0];
                    anf[0] = time;
                    return 1;
                }
                else if (time < anf[1])
                {
                    anf[2] = anf[1];
                    anf[1] = time;
                    return 2;
                }
                else if (time < anf[2])
                {
                    anf[2] = time;
                    return 3;
                }
                else return 0;
            }
            if (gd.Equals(mines.Standardeinstellungen[1]))
            {
                if (time < mittel[0])
                {
                    mittel[2] = mittel[1];
                    mittel[1] = mittel[0];
                    mittel[0] = time;
                    return 1;
                }
                else if (time < mittel[1])
                {
                    mittel[2] = mittel[1];
                    mittel[1] = time;
                    return 2;
                }
                else if (time < mittel[2])
                {
                    mittel[2] = time;
                    return 3;
                }
                else return 0;
            }
            if (gd.Equals(mines.Standardeinstellungen[2]))
            {
                if (time < profi[0])
                {
                    profi[2] = profi[1];
                    profi[1] = profi[0];
                    profi[0] = time;
                    return 1;
                }
                else if (time < profi[1])
                {
                    profi[2] = profi[1];
                    profi[1] = time;
                    return 2;
                }
                else if (time < profi[2])
                {
                    profi[2] = time;
                    return 3;
                }
                else return 0;
            }
            return -1;
        }

        //
        /// <summary>
        /// Highscores als String zurückgeben
        /// für Ausgabe in GameEnd-Anzeige
        /// </summary>
        /// <param name="gd"></param>
        /// <param name="mines"></param>
        /// <returns></returns>
        public string ToString(GameData gd, Minensucher mines)
        {
            StringBuilder sb = new StringBuilder();
            if (gd.Equals(mines.Standardeinstellungen[0]))
            {
                sb.AppendLine("Schwierigkeitsstufe: Anfänger\n");
                sb.AppendLine("1. " + anf[0]).AppendLine("2. " + anf[1]).AppendLine("3. " + anf[2]);
                sb.AppendLine("\nGewonnene Spiele: " + anf[3] + " von " + anf[4] + ".");
            }
            else if (gd.Equals(mines.Standardeinstellungen[1]))
            {
                sb.AppendLine("Schwierigkeitsstufe: Mittelstufe\n");
                sb.AppendLine("1. " + mittel[0]).AppendLine("2. " + mittel[1]).AppendLine("3. " + mittel[2]);
                sb.AppendLine("\nGewonnene Spiele: " + mittel[3] + " von " + mittel[4] + ".");
            }
            else if (gd.Equals(mines.Standardeinstellungen[1]))
            {
                sb.AppendLine("Schwierigkeitsstufe: Fortgeschritten\n");
                sb.AppendLine("1. " + profi[0]).AppendLine("2. " + profi[1]).AppendLine("3. " + profi[2]);
                sb.AppendLine("\nGewonnene Spiele: " + profi[3] + " von " + profi[4] + ".");
            }
            else
            {
                sb.AppendLine("Benutzerdefiniertes Spiel:\n");
                sb.AppendLine("Gewonnene Spiele: " + userdefined[0] + " von " + userdefined[1]);
            }
            return sb.ToString();
        }

    }
}
