﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Minen
{
    [Serializable]
    public class GameData
    {
        int height;

        public int Height
        {
            get { return height; }
            set { height = value; }
        }

        int width;

        public int Width
        {
            get { return width; }
            set { width = value; }
        }

        int mines;

        public int Mines
        {
            get { return mines; }
            set { mines = value; }
        }

        /// <summary>
        /// Standardkonstruktor für Serialisierung
        /// </summary>
        public GameData() { }

        /// <summary>
        /// Konstruktor
        /// </summary>
        /// <param name="height">Höhe</param>
        /// <param name="width">Breite</param>
        /// <param name="mines">Minen</param>
        public GameData(int height, int width, int mines)
        {
            this.height = height;
            this.width = width;
            this.mines = mines;
        }

        /// <summary>
        /// vergleicht GameData-Objekte
        /// nötig für Highscores
        /// </summary>
        /// <param name="gd"></param>
        /// <returns></returns>
        public bool Equals(GameData gd)
        {
            if (gd.Height == this.Height && gd.Width == this.Width && gd.Mines == this.Mines)
                return true;
            else return false;
        }
    }

    public class feldstatus
    {
        bool clickable;

        public bool Clickable
        {
            get { return clickable; }
            set { clickable = value; }
        }

        bool show;

        public bool Show
        {
            get { return show; }
            set { show = value; }
        }


        //-1=Mine
        int status;

        public int Status
        {
            get { return status; }
            set { status = value; }
        }

        //1=!
        //2=?
        int marked;

        public int Marked
        {
            get { return marked; }
            set { marked = value; }
        }
    }
}
