﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Drawing;

namespace Projekt
{
    public class Spieler : UserControl
    {
        public List<Karte> Blatt;

        string spielername;

        public string Spielername
        {
            get { return spielername; }
            set { spielername = value; }
        }

        bool ki;

        public bool KI
        {
            get { return ki; }
        }

        Positionen position;

        public Positionen Position
        {
            get { return position; }
        }

        public int KartenZahl
        {
            get { return Blatt.Count; }
        }

        protected Deck ZiehDeck
        {
            get { return (Parent as Form1).ZiehDeck; }
        }


        public event KarteEventHandler SpielerZug;

        int ueberlapp = 40;

        public int Ueberlapp
        {
            get { return ueberlapp; }
            set { ueberlapp = value; }
        }

        public Spieler(bool KI, Positionen position)
        {
            this.ki = KI;
            this.position = position;
            switch (position)
            {
                case Positionen.unten: this.Anchor = AnchorStyles.Bottom;
                    break;
                case Positionen.oben: this.Anchor = AnchorStyles.Top;
                    break;
                case Positionen.links: this.Anchor = AnchorStyles.Left;
                    break;
                case Positionen.rechts: this.Anchor = AnchorStyles.Right;
                    break;
                default:
                    break;
            }
            Blatt = new List<Karte>();
        }

        //Startkarten für jeden Spieler
        public void Init()
        {
            for (int i = 0; i < 5; i++)
            {
                KarteZiehen(ZiehDeck.ziehen());
            }
            //TODO Austeilen mit Zeitverzögerung
        }

        //Berechnet und zeichnet Kartenfeld neu
        void KartenZahlChanged()
        {
            switch (position)
            {
                case Positionen.unten:
                    {
                        if (KartenZahl == 1)
                            this.Size = new Size(Karte.Breite, Karte.Hoehe);
                        else if (KartenZahl == 0)
                            this.Size = new Size(0, 0);
                        else
                            this.Size = new Size(Karte.Breite + Ueberlapp * (KartenZahl - 1), Karte.Hoehe);
                        this.Location = new Point((int)((this.Parent.Width - this.Width) / 2), (int)(this.Parent.Height - 1.35 * Karte.Hoehe));
                        break;
                    }
                case Positionen.oben:
                    {
                        if (KartenZahl == 1)
                            this.Size = new Size(Karte.Breite, Karte.Hoehe);
                        else if (KartenZahl == 0)
                            this.Size = new Size(0, 0);
                        else
                            this.Size = new Size(Karte.Breite + Ueberlapp * (KartenZahl - 1), Karte.Hoehe);
                        this.Location = new Point((int)((this.Parent.Width - this.Width) / 2), (int)(0.3 * Karte.Hoehe));
                        break;
                    }
                case Positionen.links:
                    {
                        if (KartenZahl == 1)
                            this.Size = new Size(Karte.Hoehe, Karte.Breite);
                        else if (KartenZahl == 0)
                            this.Size = new Size(0, 0);
                        else
                            this.Size = new Size(Karte.Hoehe, Karte.Breite + Ueberlapp * (KartenZahl - 1));
                        this.Location = new Point((int)(0.25 * Karte.Hoehe), (int)((this.Parent.Height - this.Height) / 2));
                        break;
                    }
                case Positionen.rechts:
                    {
                        if (KartenZahl == 1)
                            this.Size = new Size(Karte.Hoehe, Karte.Breite);
                        else if (KartenZahl == 0)
                            this.Size = new Size(0, 0);
                        else
                            this.Size = new Size(Karte.Hoehe, Karte.Breite + Ueberlapp * (KartenZahl - 1));
                        this.Location = new Point((int)(this.Parent.Width - 1.3 * Karte.Hoehe), (int)((this.Parent.Height - this.Height) / 2));
                        break;
                    }
                default:
                    break;
            }
        }
              
        //Fügt Karte zum Blatt hinzu und legt neue PictureBox an
        public void KarteZiehen(Karte NeueKarte)
        {
            if (NeueKarte == null)
                return;

            Blatt.Add(NeueKarte);

            KartenZahlChanged();

            PictureBox temp = new PictureBox();
            temp.SizeMode = PictureBoxSizeMode.StretchImage;


            switch (position)
            {
                case Positionen.unten:
                    {
                        temp.Size = new Size(Karte.Breite, Karte.Hoehe);
                        temp.Location = new Point( this.Size.Width - Karte.Breite -(Blatt.Count-1)*Ueberlapp , 0 );
                        foreach (Control c in Controls)
                            c.Location = new Point(c.Location.X + Ueberlapp, 0);
                        break;
                    }
                case Positionen.oben:
                    {
                        temp.Size = new Size(Karte.Breite, Karte.Hoehe);
                        temp.Location = new Point(this.Size.Width - Karte.Breite - (Blatt.Count - 1) * Ueberlapp, 0);
                        foreach (Control c in Controls)
                            c.Location = new Point(c.Location.X + Ueberlapp, 0);
                        break;
                    }
                case Positionen.links:
                    {
                        temp.Size = new Size(Karte.Hoehe, Karte.Breite);
                        temp.Location = new Point(0, this.Size.Height - Karte.Breite);
                        break;
                    }
                case Positionen.rechts:
                    {
                        temp.Size = new Size(Karte.Hoehe, Karte.Breite);
                        temp.Location = new Point(0, 0);
                        foreach (Control c in Controls)
                            c.Location = new Point(0, c.Location.Y + Ueberlapp);
                        break;
                    }
                default:
                    break;
            }

            if (!KI)
            {
                temp.Image = NeueKarte.Bild;
                temp.Click += new EventHandler(karte_Click);       //Klick Event nur für menschlichen Spieler
            }
            else
            {
                temp.Image = KartenBilder.rueckseite;
                if (position == Positionen.links || position == Positionen.rechts)
                    temp.Image.RotateFlip( RotateFlipType.Rotate90FlipNone);
            }
            Controls.Add(temp);
            
        }
        
        //Entfernt Karte aus Blatt und löscht PictureBox
        public void KarteAblegen(Karte AlteKarte)
        {
            int index = Blatt.IndexOf(AlteKarte);
            Blatt.Remove(AlteKarte);
            Controls.RemoveAt(index);
            KartenZahlChanged();

            switch (position)
            {
                case Positionen.unten:
                    {
                        for (int i = 0; i < index; i++)
                            Controls[i].Location = new Point(Controls[i].Location.X-Ueberlapp, 0);  
                        break;
                    }
                case Positionen.oben:
                    {
                        for (int i = 0; i < index; i++)
                            Controls[i].Location = new Point( Controls[i].Location.X-Ueberlapp , 0);
                        break;
                    }                                                                                          
                case Positionen.links:
                    {
                        for (int i = index; i < KartenZahl; i++)
                            Controls[i].Location = new Point( 0 , Controls[i].Location.Y-Ueberlapp );
                            break;
                    }
                case Positionen.rechts:
                    {
                        for (int i = 0 ; i<index ; i++ )
                            Controls[i].Location = new Point(0, Controls[i].Location.Y - Ueberlapp);
                            break;
                    }
                default:
                    break;
            }




        }

        #region Events
        void karte_Click(object sender, EventArgs e)                     //löst bei Klick auf Karte ein Event aus mit Übergabe der Karte
        {
            int index = Controls.IndexOf(sender as Control);
            SpielerZug(this, new KarteEventArgs(Blatt[index]));
        }
        #endregion



        public enum Positionen
        {
            unten,
            oben,
            links,
            rechts,
        }
    }

    public class KarteEventArgs : EventArgs
    {
        Karte gewaehlteKarte;

        public Karte GewaehlteKarte
        {
            get { return gewaehlteKarte; }
        }

        public KarteEventArgs(Karte karte)
        {
            this.gewaehlteKarte = karte;
        }
    }
}
