﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Projekt
{
    public class Deck
    {
        public List<Karte> Stapel;

        static Random random;

        static Deck()
        {
            random = new Random();
        }

        public Deck()
        {
            Stapel = new List<Karte>();

        }

        public Deck(bool DeckVoll) : this()
        {
            if(DeckVoll)
                foreach (Karte.Farben f in Enum.GetValues(typeof(Karte.Farben)))
            {
                foreach (Karte.Werte w in Enum.GetValues(typeof(Karte.Werte)))
                {
                    Stapel.Add(new SchafkopfKarte(f, w));
                }
  
            }
        }


        public event EventHandler Decksvertauschen;

        public int KartenZahl
        {
            get { return Stapel.Count; }
        }

        public Karte ObersteKarte
        {
            get { return Stapel[KartenZahl - 1]; }
        }

        public Karte ziehen()
        {
            //if (KartenZahl == 0)                                                //Ziehstapel leer
            //{
            //    Decksvertauschen(this, new EventArgs());                      //Spielstapel -> Ziehstapel
            //    if (KartenZahl == 0)                                              //Spielstapel war leer -> Zieh eben keine Karte
            //        return null;
            //}

            int zufall = random.Next(KartenZahl);                               //Ziehstapel voll -> ziehe zufällige Karte
            Karte temp = Stapel[zufall];
            Stapel.RemoveAt(zufall);
            
            if (KartenZahl == 0)                                                //Ziehstapel leer
                Decksvertauschen(this, new EventArgs());
                                                            //evtl TODO: keine karte anzeigen, wenn stapel leer
            return temp;
        }

        public void ablegen(Karte karte)
        {
            Stapel.Add(karte);
        }

    }
}
