﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Pong
{
    /// <summary>
    /// Menü, das zum Abfragen von Ja/Nein-Fragen dient
    /// </summary>
    class DialogMenu : Menu
    {
        #region Variablendeklarierung

        /// <summary>
        /// Delegate für das Akzeptieren der Anfrage
        /// </summary>
        public delegate void Akzeptiert();

        /// <summary>
        /// Event für das Akzeptieren der Anfrage
        /// </summary>
        public event Akzeptiert akzeptiert;

        /// <summary>
        /// Delegate für das Ablehnen der Anfrage
        /// </summary>
        public delegate void Abgelehnt();

        /// <summary>
        /// Event für das Ablehnen der Anfrage
        /// </summary>
        public event Abgelehnt abgelehnt;

        #endregion

        #region Konstruktor

        /// <summary>
        /// Erstellt ein neues DialogMenu mit text als Abfrage
        /// </summary>
        /// <param name="text"></param>
        public DialogMenu(string text)
            : base(text)
        {
            // Anzahl der MenuItems festlegen
            items = new MenuItem[2];

            // MenuItems erstellen und in items füllen
            items[0] = new MenuItem("Ja", 10f);
            items[0].Aktiv = true;
            items[1] = new MenuItem("Nein", 10f);
         }

        #endregion

        #region Methoden

        /// <summary>
        /// Führt die Funktion hinter dem MenuItem mit Index ai aus
        /// </summary>
        /// <param name="ai"></param>
        public override void aktivieren(int ai)
        {
            switch (ai)
            {
                case 0 :
                    akzeptiert();
                    break;
                case 1 :
                    abgelehnt();
                    break;
            }
        }

        #endregion
    }
}
