﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Pong
{
    /// <summary>
    /// Eine Option für Integer-Werte
    /// </summary>
    class IntOption : Option
    {
        #region Variablendeklarierung

        /// <summary>
        /// Legt den Wert der IntOption fest
        /// </summary>
        int wert;

        /// <summary>
        /// Legt den Minimalwert der IntOption fest
        /// </summary>
        int minwert;

        /// <summary>
        /// Legt den Maximalwert der IntOption fest
        /// </summary>
        int maxwert;

        #endregion

        #region Konstruktor

        /// <summary>
        /// Erstellt eine neue IntOption mit dem Name name, dem Wert wert, dem minimalen Wert minwert und dem maximalen Wert maxwert
        /// </summary>
        /// <param name="name"></param>
        /// <param name="wert"></param>
        /// <param name="minwert"></param>
        /// <param name="maxwert"></param>
        public IntOption(string name, int wert, int minwert, int maxwert)
        {
            Name = name;
            Bildname = null;
            this.wert = wert;
            this.minwert = minwert;
            this.maxwert = maxwert;
        }

        #endregion

        #region Variablenzugriff

        /// <summary>
        /// Setzt den Wert der IntOption oder gibt diesen zurück
        /// </summary>
        public override object Wert
        {
            get { return wert; }
            set { wert = (int)value; }
        }

        /// <summary>
        /// Setzt den Minimalwert der IntOption oder gibt diesen zurück
        /// </summary>
        public int Minwert
        {
            get { return minwert; }
            set { minwert = value; }
        }

        /// <summary>
        /// Setzt den Maximalwert der IntOption oder gibt diesen zurück
        /// </summary>
        public int Maxwert
        {
            get { return maxwert; }
            set { maxwert = value; }
        }
        
        #endregion
    }
}
