﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Pong
{
    /// <summary>
    /// Oberklasse für alle in der Anwendung vorkommenden Optionen
    /// </summary>
    abstract class Option
    {
        #region Variablendeklarierung

        /// <summary>
        /// Legt den Namen der Option fest
        /// </summary>
        string name;

        /// <summary>
        /// Legt den Wert der Option fest
        /// </summary>
        object wert;

        /// <summary>
        /// Legt den Namen des zur Option gehörenden Bildes fest
        /// </summary>
        string bildname;

        #endregion

        #region Variablenzugriff

        /// <summary>
        /// Setzt den Namen der Option oder gibt diesen zurück
        /// </summary>
        public string Name
        {
            get { return name; }
            set { name = value; }
        }

        /// <summary>
        /// Setzt den Wert der Option oder gibt diesen zurück
        /// </summary>
        public virtual object Wert
        {
            get { return wert; }
            set { wert = value; }
        }

        /// <summary>
        /// Setzt den Namen des zur Option gehörenden Bildes oder gibt diesen zurück
        /// </summary>
        public string Bildname
        {
            get { return bildname; }
            set { bildname = value; }
        }

        #endregion
    }
}
