﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SdlDotNet.Input;

namespace Pong
{
    /// <summary>
    /// Ein InputItem für das Eingeben von TextOptionen
    /// </summary>
    class TextInputItem : InputItem
    {
        #region Variablendeklarierung

        /// <summary>
        /// Legt die TextOption für das TextInputItem fest
        /// </summary>
        TextOption textoption;

       #endregion

        #region Konstruktor
        
        /// <summary>
        /// Erstellt ein neues TextInputItem mit der TextOption textoption und der Schriftgröße schrift
        /// </summary>
        /// <param name="textoption"></param>
        /// <param name="schrift"></param>
        public TextInputItem(TextOption textoption, Single schrift)
            : base(textoption, schrift)
        {
            this.textoption = textoption;
        }

        #endregion

        #region Variablenzugriff

        /// <summary>
        /// Setzt die Aufschrift des TextInputItems oder gibt diese zurück
        /// </summary>
        public string Aufschrift
        {
            get { return textoption.Name; }
            set { textoption.Name = value;
                Name = textoption.Name + ": " + textoption.Wert; }
        }

        /// <summary>
        /// Setzt den momentan eingegebenen Text oder gibt diesen zurück
        /// </summary>
        public string Text
        {
            get { return textoption.Wert.ToString(); }
            set { textoption.Wert = value;
                Name = textoption.Name + ": " + textoption.Wert; }
        }

        #endregion

        #region Methoden

        /// <summary>
        /// Verarbeitet das Drücken von Tasten
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public override void Events_Keydown(object sender, KeyboardEventArgs e)
        {
            if (e.Key == Key.Backspace)
            {
                if (Text.Length > 0)
                    Text=Text.Remove(Text.Length-1);
            }
            else
            {
                if (Text.Length < 50)
                {
                    if (e.Key.ToString().Length == 1)
                        Text += e.Key.ToString();
                    else if (e.Key == Key.Space)
                        Text += " ";
                }
            }
        }

        #endregion
    }
}
