﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SdlDotNet.Input;

namespace Pong
{
    /// <summary>
    /// Oberklasse für alle in der Anwendung vorkommenden Eingabemöglichkeiten
    /// </summary>
    abstract class InputItem : MenuItem
    {
        #region Konstruktor

        /// <summary>
        /// Erstellt ein neues InputItem aus der Option option und mit der Schriftgröße schrift
        /// </summary>
        /// <param name="option"></param>
        /// <param name="schrift"></param>
        public InputItem(Option option, Single schrift)
            : base(option.Name + ": " + option.Wert.ToString(), option.Bildname, schrift)
        {

        }

        #endregion

        #region Methoden

        /// <summary>
        /// Verarbeitet das Drücken von Tasten
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public abstract void Events_Keydown(object sender, KeyboardEventArgs e);

        #endregion
    }
}
