﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SdlDotNet.Input;

namespace Pong
{
    /// <summary>
    /// Ein InputItem für das Auswählen von AuswahlOptionen
    /// </summary>
    class AuswahlInputItem : InputItem
    {
        #region Variablendeklarierung

        /// <summary>
        /// Legt die AuswahlOption für das AuswahlInputItem fest
        /// </summary>
        AuswahlOption auswahloption;

        #endregion

        #region Konstruktor

        /// <summary>
        /// Erstellt ein neues AuswahlInputItem mit der AuswahlOption auswahloption und der Schriftgröße schrift
        /// </summary>
        /// <param name="auswahloption"></param>
        /// <param name="schrift"></param>
        public AuswahlInputItem(AuswahlOption auswahloption, Single schrift)
            : base(auswahloption, schrift)
        {
            this.auswahloption = auswahloption;
            
            // Aktualisiert die Anzeige
            Name = auswahloption.Name + ": " + auswahloption.Auswahl[(int)auswahloption.Wert];
        }

        #endregion

        #region Variablenzugriff

        /// <summary>
        /// Setzt die Aufschrift des IntInputItems oder gibt diese zurück
        /// </summary>
        public string Aufschrift
        {
            get { return auswahloption.Name; }
            set { auswahloption.Name = value;
                Name = auswahloption.Name + ": " + auswahloption.Auswahl[(int)auswahloption.Wert]; }
        }

        /// <summary>
        /// Setzt den momentan ausgewählten Wert oder gibt diesen zurück
        /// </summary>
        public int Wert
        {
            get { return (int)auswahloption.Wert; }
            set { auswahloption.Wert = value;
                Name = auswahloption.Name + ": " + auswahloption.Auswahl[(int)auswahloption.Wert]; }
        }

        #endregion

        #region Methoden

        /// <summary>
        /// Verarbeitet das Drücken von Tasten
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public override void Events_Keydown(object sender, KeyboardEventArgs e)
        {
            if (e.Key == Key.UpArrow)
            {
                if (Wert < auswahloption.Auswahl.Length - 1)
                    Wert += 1;
                else
                    Wert = 0;
            }
            else if (e.Key == Key.DownArrow)
            {
                if (Wert > 0)
                    Wert -= 1;
                else
                    Wert = auswahloption.Auswahl.Length - 1;
            }
        }

        #endregion
    }
}
