﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SdlDotNet.Audio;

namespace Pong
{
    /// <summary>
    /// EventItem, das den Ball nach Links beschleunigt bzw. abbremst
    /// </summary>
    class BoostLinksItem : EventItem
    {
        #region Konstruktor

        /// <summary>
        /// Erstellt ein neues BoostLinksItem mit dem Random random
        /// </summary>
        /// <param name="random"></param>
        public BoostLinksItem(Random random)
            : base("BoostLinks.png", random)
        {
            
        }

        #endregion

        #region Methoden

        /// <summary>
        /// Beschleunigt den Ball nach links bzw. bremst den Ball ab
        /// </summary>
        /// <param name="seite"></param>
        public override void getroffen(Spieler.Seite seite, Ball ball)
        {
            if (ball.BallSpeedX > 0)
            {
                treffer = new Sound("Abbremsung.wav");
                ball.BallSpeedX /= 2;
            }
            else
            {
                treffer = new Sound("Beschleunigung.wav");
                ball.BallSpeedX *= 1.5;
            }

            base.getroffen(seite, ball);
        }

        #endregion
    }
}
