﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SdlDotNet.Graphics;
using SdlDotNet.Audio;

namespace Pong
{
    /// <summary>
    /// Allgemeine Oberklasse für alle im Spiel auftauchenden Items, die die Spieler mit dem Ball aktivieren können
    /// </summary>
    abstract class EventItem : PongItem
    {
        #region Variablendeklarierung

        /// <summary>
        /// Legt fest, ob das EventItem gerade im Spiel ist
        /// </summary>
        bool aktiv;

        /// <summary>
        /// Zufallszahlengenerator für die Positionierung
        /// </summary>
        Random random;

        /// <summary>
        /// Legt fest, ob das EventItem im Spiel auftreten darf oder nicht
        /// </summary>
        bool verwendet;

        /// <summary>
        /// Legt den Namen des EventItems fest
        /// </summary>
        string name;

        protected Sound treffer;

        #endregion

        #region Konstruktor

        /// <summary>
        /// Erstellt ein neues EventItem mit einem Sprite aus der Datei name und dem Random random
        /// </summary>
        /// <param name="name"></param>
        /// <param name="random"></param>
        public EventItem(string name, Random random)
            : base(name)
        {
            this.name = name.Remove(name.IndexOf("."));
            this.random = random;

            // Standardmäßig werden alle EventItems verwendet
            verwendet = true;

            // Standardmäßig sind alle EventItems zu Beginn des Spiels inaktiv
            aktiv = false;
        }

        #endregion

        #region Variablenzugriff

        /// <summary>
        /// Setzt das EventItem in oder aus dem Spiel oder gibt zurück, ob dieses im Spiel ist
        /// </summary>
        public bool Aktiv
        {
            get { return aktiv; }
            set
            {
                aktiv = value;
                if (aktiv) positionieren();
                else Pongmaster.Eventitemaktiv = false;
            }
        }

        /// <summary>
        /// Setzt, ob das EventItem im Spiel verwendet werden darf, oder gibt dies zurück
        /// </summary>
        public bool Verwendet
        {
            get { return verwendet; }
            set { verwendet = value; }
        }

        /// <summary>
        /// Gibt den Namen des EventItems zurück
        /// </summary>
        public string Name
        {
            get { return name; }
        }

        #endregion

        #region Methoden

        /// <summary>
        /// Führt das jeweilige Ereignis hinter dem EventItem aus
        /// </summary>
        /// <param name="seite"></param>
        /// <param name="ball"></param>
        public virtual void getroffen(Spieler.Seite seite, Ball ball)
        {
            Aktiv = false;
            
            if (treffer!=null)
                treffer.Play();
        }

        /// <summary>
        /// Zeichnet das EventItem, wenn es gerade im Spiel ist
        /// </summary>
        public override void draw()
        {
            if (aktiv)
                base.draw();
        }

        /// <summary>
        /// Positioniert das EventItem zufällig im Spielfeld
        /// </summary>
        private void positionieren()
        {
            // Zufällige Positionierung mindestens 100 Pixel vom Rand entfernt
            X = 100 + random.Next(Video.Screen.Width - 199 - Width);
            Y = 100 + random.Next(Video.Screen.Height - 199 - Height);
        }

        #endregion
    }
}
