﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SdlDotNet.Input;

namespace Pong
{
    /// <summary>
    /// Ein InputItem für das Auswählen von IntOptionen
    /// </summary>
    class IntInputItem : InputItem
    {
        #region Variablendeklarierung

        /// <summary>
        /// Legt die IntOption für das IntInputItem fest
        /// </summary>
        IntOption intoption;

        #endregion

        #region Konstruktor
        
        /// <summary>
        /// Erstellt ein neues IntInputItem mit der IntOption intoption und der Schriftgröße schrift
        /// </summary>
        /// <param name="intoption"></param>
        /// <param name="schrift"></param>
        public IntInputItem(IntOption intoption, Single schrift)
            : base(intoption, schrift)
        {
            this.intoption = intoption;
        }

        #endregion

        #region Variablenzugriff

        /// <summary>
        /// Setzt die Aufschrift des IntInputItems oder gibt diese zurück
        /// </summary>
        public string Aufschrift
        {
            get { return intoption.Name; }
            set { intoption.Name = value;
                Name = intoption.Name + ": " + Wert; }
        }
        
        /// <summary>
        /// Setzt den momentan ausgewählten Wert oder gibt diesen zurück
        /// </summary>
        public int Wert
        {
            get { return (int)intoption.Wert; }
            set { intoption.Wert = value;
                Name = intoption.Name + ": " + intoption.Wert; }
        }

        /// <summary>
        /// Setzt den Minimalwert des IntInputItems oder gibt diesen zurück
        /// </summary>
        public int Minwert
        {
            get { return intoption.Minwert; }
            set { intoption.Minwert = value;
                if (Wert < intoption.Minwert)
                    Wert = intoption.Minwert; }
        }

        /// <summary>
        /// Setzt den Maximalwert des IntInputItems oder gibt diesen zurück
        /// </summary>
        public int Maxwert
        {
            get { return intoption.Maxwert; }
            set { intoption.Maxwert = value;
                if (Wert > intoption.Maxwert)
                    Wert = intoption.Maxwert; }
        }
        
        #endregion

        #region Methoden

        /// <summary>
        /// Verarbeitet das Drücken von Tasten
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public override void Events_Keydown(object sender, KeyboardEventArgs e)
        {
            if (e.Key == Key.UpArrow)
            {
                if (Wert < Maxwert)
                    Wert += 1;
                else
                    Wert = Minwert;
            }
            else if (e.Key == Key.DownArrow)
            {
                if (Wert > Minwert)
                    Wert -= 1;
                else
                    Wert = Maxwert;
            }
        }

        #endregion
    }
}
