﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SdlDotNet.Graphics;
using SdlDotNet.Core;
using SdlDotNet.Input;
using System.Drawing;

namespace Pong
{
    /// <summary>
    /// Oberklasse für alle in der Anwendung vorkommenden Menüs
    /// </summary>
    class Menu
    {
        #region Variablendeklarierung

        /// <summary>
        /// Das Item, das den Titel des Menüs darstellt
        /// </summary>
        protected MenuItem titelItem;

        /// <summary>
        /// Legt den Namen des Menüs fest
        /// </summary>
        string name;

        /// <summary>
        /// Enthält alle MenüPunkte des Menüs als MenuItems
        /// </summary>
        protected MenuItem[] items;

        /// <summary>
        /// Bezeichnet den Index des aktuell aktiven MenuItems
        /// </summary>
        int aktivIndex;

        #endregion

        #region Konstruktor

        /// <summary>
        /// Erstellt ein neues Menü mit dem Namen name
        /// </summary>
        /// <param name="name"></param>
        public Menu(string name)
        {
            this.name = name;
            titelItem = new MenuItem(name, 14f);
            aktivIndex = 0;
        }

        #endregion

        #region Variablenzugriff

        /// <summary>
        /// Setzt den Namen dieses Menüs oder gibt ihn zurück
        /// </summary>
        public string Name
        {
            get { return name; }
            set { name = value; titelItem.Name = name; }
        }

        #endregion

        #region Methoden

        /// <summary>
        /// Wird beim Zeichnen jedes Frames aufgerufen
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public virtual void Events_Tick(object sender, TickEventArgs e)
        {
            draw();
            Video.Screen.Update();
        }


        /// <summary>
        /// Wird bei jedem Drücken einer Taste aufgerufen
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public virtual void Events_Keydown(object sender, KeyboardEventArgs e)
        {
            // Pfeil hoch fährt das rechts Paddle hoch
            if (e.Key == Key.UpArrow)
            {
                //Deaktiviert das aktuell aktive MenuItem
                items[aktivIndex].Aktiv = false;
                
                // Setzt den AktivIndex zurück
                aktivIndex -= 1;
                if (aktivIndex < 0)
                    aktivIndex = items.Length - 1;

                // Aktiviert das neu ausgewählte MenuItem
                items[aktivIndex].Aktiv = true;
            }
            // Pfeil runter fährt das rechte Paddle runter
            else if (e.Key == Key.DownArrow)
            {
                //Deaktiviert das aktuell aktive MenuItem
                items[aktivIndex].Aktiv = false;

                // Setzt den AktivIndex zurück
                aktivIndex += 1;
                if (aktivIndex >= items.Length)
                    aktivIndex = 0;

                // Aktiviert das neu ausgewählte MenuItem
                items[aktivIndex].Aktiv = true;
            }
            else if (e.Key == Key.Return)
            {
                aktivieren(aktivIndex);
            }
        }

        /// <summary>
        /// Löst die Funktion hinter dem MenuItem mit dem Index ai aus
        /// </summary>
        /// <param name="ai"></param>
        public virtual void aktivieren(int ai)
        {

        }

        /// <summary>
        /// Zeichnet das Menü mit allen enthaltenen MenüItems
        /// </summary>
        public void draw()
        {
            // Erstmal alles wegmachen
            Video.Screen.Fill(Color.Black);

            // x- und y-Positon des TitelItems festlegen und dann das TitelItem zeichnen
            titelItem.X = (Video.Screen.Width - titelItem.Width) / 2;
            titelItem.Y = 20;
            titelItem.draw();

            // aktuelle Position beim Zeichnen
            double aktuellesY = titelItem.Y + titelItem.Height;

            foreach (MenuItem mi in items)
            {
                // x- und y-Positon des MenuItems festlegen und dann das MenuItem zeichnen
                mi.X = (Video.Screen.Width - mi.Width) / 2;
                mi.Y = aktuellesY + 20;
                mi.draw();

                // Aktuelle Position beim Zeichnen weitersetzen
                aktuellesY += mi.Height + 20;
            }
        }

        #endregion
    }
}
