﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using SdlDotNet.Graphics;
using SdlDotNet.Graphics.Sprites;

namespace Pong
{
    class MenuItem : SDLItem
    {
        #region Variablendeklarierung

        /// <summary>
        /// Legt fest, ob das MenüItem derzeit vom Anwender ausgewählt ist
        /// </summary>
        bool aktiv;

        /// <summary>
        /// Legt die Aufschrift des MenüItems fest
        /// </summary> 
        string name;

        /// <summary>
        /// Legt die Schriftgröße des Textes des MenuItems fest
        /// </summary>
        Single schrift;

        /// <summary>
        /// Legt den Namen des Bildes fest, das am Anfang des MenuItems platziert ist
        /// </summary>
        string bildname;

        /// <summary>
        /// Legt die Breite der Bitmap fest
        /// </summary>
        //int breite;

        #endregion

        #region Konstruktor

        /// <summary>
        /// Erstellt ein MenuItem mit der Aufschrift name und der Schriftgröße schrift
        /// </summary>
        /// <param name="text"></param>
        /// <param name="schrift"></param>
        public MenuItem(string name, Single schrift)
        {
            this.schrift=schrift;
            this.name = name;
            bildname = null;

            // Standardwert für die Breite
            //breite = Video.Screen.Width;

            // Sprite erstellen
            update();
        }

        /// <summary>
        /// Erstellt ein MenuItem mit der Aufschrift name, dem Bild mit Namen bildname und der Schriftgröße schrift
        /// </summary>
        /// <param name="name"></param>
        /// <param name="bildname"></param>
        /// <param name="schrift"></param>
        public MenuItem(string name, string bildname, Single schrift)
        {
            this.schrift = schrift;
            this.name = name;
            this.bildname = bildname;

            // Standardwert für die Breite
            //breite = Video.Screen.Width;

            // Sprite erstellen
            update();
        }

        #endregion

        #region Variablenzugriff


        /// <summary>
        /// Setzt den Wert aktiv für das MenuItem oder gibt diesen zurück
        /// </summary>
        public bool Aktiv
        {
            get { return aktiv; }
            set { aktiv = value; update(); }
        }

        /// <summary>
        /// Setzt den Text des MenuItems oder gibt diesen zurück
        /// </summary>
        public string Name
        {
            get { return name; }
            set { name = value; update();  }
        }

        /// <summary>
        /// Setzt den Namen des Bildes oder gibt diesen zurück (null, falls kein Bild verwendet wird)
        /// </summary>
        public string Bildname
        {
            get { return bildname; }
            set { bildname = value; }
        }

        #endregion

        #region Methoden
        
        /// <summary>
        /// Erneuert den Sprite des MenuItems
        /// </summary>
        protected void update()
        {
            //Bitmap b = new Bitmap(breite, 50);
            Bitmap b = new Bitmap(Video.Screen.Width, 30);

            Brush brush;

            if (aktiv)
                brush = Brushes.Yellow;
            else
                brush = Brushes.Red;

            using (Graphics g = Graphics.FromImage(b))
            {
                if (bildname != null)
                {
                    Bitmap bild = new Bitmap(bildname);
                    g.DrawImageUnscaled(bild, 0, 0);
                    g.DrawString(Name, new System.Drawing.Font("Tahoma", schrift), brush, new PointF(bild.Width + 10, 0));
                }
                else
                    g.DrawString(Name, new System.Drawing.Font("Tahoma", schrift), brush, new PointF(0, 0));
            }

            Surface surf = new Surface(b);

            if (sprite == null)
                sprite = new Sprite(surf, new Point((int)X, (int)Y));
            else
                sprite.Surface = surf;
        }

        #endregion
    }
}
