﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SdlDotNet.Graphics.Sprites;
using SdlDotNet.Graphics;
using System.Drawing;

namespace Pong
{
    /// <summary>
    /// Zeigt den Punktestand im Spiel an
    /// </summary>
    class Punktestand : PongItem
    {
        #region Konstruktor

        /// <summary>
        /// Erstellt eine Instanz vom Punktestand
        /// </summary>
        public Punktestand()
        {
            
        }

        #endregion

        #region Methoden

        /// <summary>
        /// Erneuert den Sprite des Punktestands
        /// </summary>
        public void update(int psl, int psr)
        {
            Bitmap b = new Bitmap(60, 20);

            using (Graphics g = Graphics.FromImage(b))
            {
                g.DrawString(psl + " - " + psr, new System.Drawing.Font("Tahoma", 10f), Brushes.Red, new PointF(0, 0));
            }

            Surface surf = new Surface(b);

            if (sprite == null)
                sprite = new Sprite(surf, new Point((int)X, (int)Y));
            else
                sprite.Surface = surf;
        }


        /// <summary>
        /// Zeichnet den Sprite des Punktestands und ändert diesen
        /// </summary>
        public override void draw()
        {
            // Punkte des linken bzw. rechten Spielers
            int psl = 0;
            int psr = 0;
            
            foreach (PongItem pi in Pongmaster.Items)
            {
                if (pi is Spieler && (pi as Spieler).Seit == Spieler.Seite.Links)
                    psl = (pi as Spieler).Punkte;
                else if (pi is Spieler && (pi as Spieler).Seit == Spieler.Seite.Rechts)
                    psr = (pi as Spieler).Punkte;
            }

            if (psl >= (int)Pongmaster.Optionen[(int)Pong.Optionen.SiegPunkte].Wert && psr >= (int)Pongmaster.Optionen[(int)Pong.Optionen.SiegPunkte].Wert)
            {
                Pongmaster.Stat = PongMaster.Status.NochmalAbfrage;
                Pongmaster.nochmalabfrage.Name = "Beide Spieler haben die Siegpunktzahl erreicht, das Spiel endet unentschieden! Nochmal spielen?";
            }
            else if (psl >= (int)Pongmaster.Optionen[(int)Pong.Optionen.SiegPunkte].Wert)
            {
                Pongmaster.Stat = PongMaster.Status.NochmalAbfrage;
                Pongmaster.nochmalabfrage.Name = Pongmaster.Optionen[(int)Pong.Optionen.NameLinkerSpieler].Wert+" hat gewonnen! Nochmal spielen?";
            }
            else if (psr >= (int)Pongmaster.Optionen[(int)Pong.Optionen.SiegPunkte].Wert)
            {
                Pongmaster.Stat = PongMaster.Status.NochmalAbfrage;
                Pongmaster.nochmalabfrage.Name = Pongmaster.Optionen[(int)Pong.Optionen.NameRechterSpieler].Wert + " hat gewonnen! Nochmal spielen?";
            }

            // Aktualisierung der Anzeige
            update(psl, psr);
            
            // Neuzeichnen
            base.draw();
        }

        #endregion
    }
}
