﻿using System;
using System.IO;
using System.Drawing;
using System.Windows.Forms;
using System.Drawing.Imaging;
using System.Drawing.Drawing2D;

namespace Puzzle
{

    public partial class StartForm : Form
    {
              
        public StartForm()
        {
            InitializeComponent();
        }
        #region "Public Methods"

        public static Image resizeImage(Image imgToResize, Size size)
        {
            int sourceWidth = imgToResize.Width;
            int sourceHeight = imgToResize.Height;
            float nPercent = 0;
            float nPercentW = 0;
            float nPercentH = 0;

            nPercentW = ((float)size.Width / (float)sourceWidth);
            nPercentH = ((float)size.Height / (float)sourceHeight);

            if (nPercentH < nPercentW)
                nPercent = nPercentH;
            else
                nPercent = nPercentW;

            int destWidth = (int)(sourceWidth * nPercent);
            int destHeight = (int)(sourceHeight * nPercent);

            Bitmap b = new Bitmap(destWidth, destHeight);
            Graphics g = Graphics.FromImage((Image)b);
            g.InterpolationMode = InterpolationMode.HighQualityBicubic;

            g.DrawImage(imgToResize, 0, 0, destWidth, destHeight);
            g.Dispose();

            return (Image)b;
        }

        public static Image resizeAndCropImage(Image imgToResize)
        {
            // bild mit dem neuen format erstellen  
            Bitmap pi = new Bitmap(600, 600);

            if (imgToResize.Height <= imgToResize.Width)
            {
                double height = 600;
                double fac = height / imgToResize.Height;
                double width = fac * imgToResize.Width;

                // bild mit der neuen größe erstellen  
                Bitmap ni = new Bitmap((int)width, (int)height);

                // größenverändertes bild erstellen  
                using (Graphics g = Graphics.FromImage(ni))
                {
                    g.InterpolationMode = InterpolationMode.HighQualityBicubic;
                    g.DrawImage(imgToResize, new Rectangle(0, 0, (int)width, (int)height));
                }
                // bildausschnitt festlegen  
                Rectangle sourcerec = new Rectangle((ni.Width - 600) / 2, 0, 600, 600);
                Rectangle targetrec = new Rectangle(0, 0, 600, 600);

                // ausschneiden und ins neue bild packen  
                using (Graphics g = Graphics.FromImage(pi))
                {
                    g.InterpolationMode = InterpolationMode.HighQualityBicubic;
                    g.DrawImage(ni, targetrec, sourcerec, GraphicsUnit.Pixel);
                    g.Dispose();
                }
            }

            else if (imgToResize.Width < imgToResize.Height)
            {
                double width = 600;
                double fac = width / imgToResize.Width;
                double height = fac * imgToResize.Height;
                Bitmap ni = new Bitmap((int)width, (int)height);

                using (Graphics g = Graphics.FromImage(ni))
                {
                    g.InterpolationMode = InterpolationMode.HighQualityBicubic;
                    g.DrawImage(imgToResize, new Rectangle(0, 0, (int)width, (int)height));
                }

                Rectangle source = new Rectangle(0, (ni.Height - 600) / 2, 600, 600);
                Rectangle target = new Rectangle(0, 0, 600, 600);
                using (Graphics g = Graphics.FromImage(pi))
                {
                    g.InterpolationMode = InterpolationMode.HighQualityBicubic;
                    g.DrawImage(ni, target, source, GraphicsUnit.Pixel);
                    g.Dispose();
                }
            }
            ImageFormat imgf = ImageFormat.Png;
            return (Image)pi;
        }

        public static void SplitImage(Image source, int imageX, int imageY, string target)
        {
            if (!Directory.Exists(target))
                Directory.CreateDirectory(target);

            Bitmap original = new Bitmap(source);
            Rectangle focusRectangle = new Rectangle();
            Bitmap destination;

            for (int x = 0; x <= imageX - 1; x++)
            {
                for (int y = 0; y <= imageY - 1; y++)
                {
                    focusRectangle.X = x * (original.Width / imageX);
                    focusRectangle.Y = y * (original.Height / imageY);
                    focusRectangle.Height = original.Height / imageX;
                    focusRectangle.Width = original.Width / imageY;

                    destination = original.Clone(focusRectangle, PixelFormat.DontCare);
                    destination.Save(target + "Img" + y.ToString() + x.ToString() + ".png");
                }
            }
        }

        # endregion

        #region "Private Methods"

        private void buttonStart_Click(object sender, EventArgs e)
        {
            Puzzle start = new Puzzle();
            this.Hide();
            if (start.ShowDialog() == DialogResult.OK)
            {
                this.Show();
            }
        }

        private void buttonGetImage_Click(object sender, EventArgs e)
        {     
            string file;
            Stream myStream;
            OpenFileDialog openFileDialog1 = new OpenFileDialog();
            Size picBoxSize = new Size(300, 300);
            openFileDialog1.InitialDirectory = Application.StartupPath + @"\Images\Examples";
            openFileDialog1.Filter = "Bildformate " + "(*.jpg;*.gif;*.bmp;*.png)|*.jpg;*.gif;*.bmp;*.png";
            openFileDialog1.FilterIndex = 2;
            openFileDialog1.RestoreDirectory = true;
            label1.Visible = true;

            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                if ((myStream = openFileDialog1.OpenFile()) != null)
                {
                    file = openFileDialog1.FileName;
                    buttonGetImage.Visible = false;
                    this.pictureBox2.Image = resizeImage(resizeAndCropImage((Image.FromFile(file))), picBoxSize);
                    SplitImage(resizeAndCropImage((Image.FromFile(file))), 4, 4, (Application.UserAppDataPath + @"\Images\Temp\")); // Bild zerschneiden 
                    SplitImage(resizeAndCropImage((Image.FromFile(file))), 1, 1, (Application.UserAppDataPath + @"\Images\TempPreview\"));
                    myStream.Close();
                    label1.Visible = false;
                }
            }


        }

        private void buttonInfo_Click(object sender, EventArgs e)
        {
            InfoForm info = new InfoForm();
            if (info.ShowDialog() == DialogResult.OK)
            {
                this.Show();
            }
        }
        # endregion
    }
}













































