﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;

namespace CSharpProjekt {
    public abstract class Karte {
        string name;
        int[] kosten;
        Image bild;

        public Image Bild {
            get { return bild; }
            set { bild = value; }
        }

        public int[] Kosten {
            get { return kosten; }
            set { kosten = value; }
        }
        List<IAttribut> attribute;

        public List<IAttribut> Attribute {
            get { return attribute; }
            set { attribute = value; }
        }
        string art;

        public string Art {
            get { return art; }
            set { art = value; }
        }

        public string Name {
            get { return name; }
            set { name = value; }
        }


        public Karte () {
            kosten = new int[Spiel.RohstoffAnzahl];
            for (int i = 0; i < kosten.Length; i++) {
                kosten[i] = 0;
            }

            attribute = new List<IAttribut> (4);
        }

        /// <summary>
        /// Die Kosten der Karte werden vom Rohstoffvorrat entnommen und die Auswirkungen der Karte treten in Kraft
        /// </summary>
        /// <param name="ausspieler">Der Spieler der die Karte ausgespielt hat</param>
        public virtual void Ausführen(Spieler ausspieler)
        {
            ausspieler.RohstoffvorratVerändern(-kosten[(int)RohstoffListe.nahrung], -kosten[(int)RohstoffListe.gold], -kosten[(int)RohstoffListe.steine]);
            foreach (IAttribut attr in attribute) {
                attr.Ausführen (ausspieler);
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns>Den Text der auf der Karte lesbar ist</returns>
        public String FormatiereAttribute () {
            StringBuilder sb = new StringBuilder ();
            foreach (IAttribut attr in attribute) {
                sb.Append(attr.ToString () + "\n");
            }
            return sb.ToString();
        }

        public String FormatiereKosten () {
            return (kosten[(int)RohstoffListe.nahrung] > 0 ? kosten[(int)RohstoffListe.nahrung] + "N " : String.Empty)
                + (kosten[(int)RohstoffListe.gold] > 0 ? kosten[(int)RohstoffListe.gold] + "G " : String.Empty)
                + (kosten[(int)RohstoffListe.steine] > 0 ? kosten[(int)RohstoffListe.steine] + "S " : String.Empty);
        }

        public bool prüfeObAusreichendRohstoffeVorhanden(Spieler spieler) {
            for (int i = 0; i < Kosten.Length; i++) {
                if (spieler.Rohstoffe[i] < Kosten[i])
                    return false;
            }
            return true;
        }

    }

    
}
