﻿using System;
using System.Collections.Generic;
using System.Text;

namespace CSharpProjekt {
    public abstract class Angriffskarte : Karte{

        public Angriffskarte () : base () {
            Art = "Angriff";
        }

        /// <summary>
        /// Führt zunächst die normalen Attribute aus, dannach greift der Ausspieler seinen Gegner an
        /// </summary>
        /// <param name="ausspieler">Der Spieler der die Karte ausgespielt hat</param>
        public override void Ausführen(Spieler ausspieler) {
            base.Ausführen(ausspieler);
            // da der Angriffsbonus einen Kampf betrifft und nicht einen Spieler kann er nicht auf normalem Weg über das IAttribut behandelt werden
            int angriffsBonus = 0;
            bool untertunnelt = false;
            foreach (IAttribut attr in Attribute) {
                if (attr is AngriffsBonus)
                    angriffsBonus += (attr as AngriffsBonus).Bonus;
                if (attr is Untertunnelt)
                    untertunnelt = true;
            }

            Kampf kampf = new Kampf(ausspieler, angriffsBonus, untertunnelt);
        }
    }
}
