﻿using System;
using System.Collections.Generic;
using System.Text;

namespace CSharpProjekt {
    public class Spieler {


        String name;
        int lebenspunkte;
        int mauer;
        Armee armee;
        int[] prod;
        int[] rohstoffe;
        List<Karte> handkarten;
        bool menschlich;
        int aktionen;
        Spieler gegner;
        SpielerControl control;

        public SpielerControl Control {
            get { return control; }
            set { control = value; }
        }
        public Spieler Gegner {
            get { return gegner; }
            set { gegner = value; }
        }
        public int Aktionen {
            get { return aktionen; }
            set { aktionen = value; }
        }
        public int Lebenspunkte {
            get { return lebenspunkte; }
            set { lebenspunkte = value; }
        }
        public int Mauer {
            get { return mauer; }
            set { mauer = value; }
        }
        public int[] Prod {
            get { return prod; }
            set { prod = value; }
        }
        public Armee Armee {
            get { return armee; }
            set { armee = value; }
        }
        public int[] Rohstoffe {
            get { return rohstoffe; }
            set { rohstoffe = value; }
        }
        public List<Karte> Handkarten {
            get { return handkarten; }
            set { handkarten = value; }
        }
        public bool Menschlich {
            get { return menschlich; }
            set { menschlich = value; }
        }
        public String Name {
            get { return name; }
            set { name = value; }
        }
        
        /// <summary>
        /// Erzeugt Computerspieler
        /// </summary>
        public Spieler () {
            name = "Computer";
            menschlich = false;
            lebenspunkte = Spiel.LebenStartwert;
            mauer = Spiel.MauerStartwert;
            
            armee = new Armee();

            prod = new int[Spiel.RohstoffAnzahl];
            for (int i = 0; i < prod.Length; i++) {
                prod[i] = Spiel.ProduktionStartwert;
            }

            rohstoffe = new int[Spiel.RohstoffAnzahl];
            for (int i = 0; i < rohstoffe.Length; i++) {
                rohstoffe[i] = Spiel.RohstoffeStartwert;
            }
        }

        /// <summary>
        /// Erzeugt menschlichen Spieler
        /// </summary>
        /// <param name="name"></param>
        public Spieler (String name) : this () {
            this.name = name;
            menschlich = true;
        }

        /// <summary>
        /// Ändert die Rohstoffe des Spielers um die übergebenen Werte (die auch negativ sein dürfen)
        /// </summary>
        /// <param name="nahrung"></param>
        /// <param name="gold"></param>
        /// <param name="stein"></param>
        public void RohstoffvorratVerändern(int nahrung, int gold, int stein) {
            rohstoffe[(int)RohstoffListe.nahrung] += nahrung;
            rohstoffe[(int)RohstoffListe.gold] += gold;
            rohstoffe[(int)RohstoffListe.steine] += stein;
        }

        /// <summary>
        /// Spieler zieht eine Karte falls seine Kartenanzahl unter dem erlaubten Maximum liegt
        /// </summary>
        /// <param name="rand">die übergebene Random-Instanz</param>
        /// <returns>die gezogene Karte</returns>
        public Karte KarteZiehen (Random rand) {
            if (handkarten.Count >= Spiel.MaxKartenAnzahl)
                return null;

            Karte karte = new KartenGenerator().KarteGenerieren(rand);
            handkarten.Add (karte);
            foreach (KarteControl kc in control.KartenControls) {
                if (kc.Karte == null) {
                    kc.KarteZuweisen(karte);
                    control.Zuordnung[kc].Enabled = true;
                    break;
                }
            }
            
            return karte;
        }

        /// <summary>
        /// Beschädigt die Stadt, im Normalfall geht der Schaden zuerst auf die Stadtmauer und erst wenn diese zerstört ist auf die Lebenspunkte
        /// </summary>
        /// <param name="schaden">Schaden den die Stadt nimmt</param>
        /// <param name="tunnel">ob die Stadtmauer aufgrund des Attributs Untertunnelt ignoriert werden soll</param>
        public void StadtBeschädigen(int schaden, bool tunnel) {
            if (tunnel)
                Lebenspunkte -= schaden;
            else {
                if (Mauer >= schaden) { // Mauer fängt allen Schaden ab
                    Mauer -= schaden;
                } else { // Schaden ist größer als Mauer, so dass auch die Lebenspunkte betroffen sind
                    Lebenspunkte -= (schaden - Mauer);
                    Mauer = 0;
                }
            }
        }

        public override String ToString() {
            return name;
        }
    }


    public enum RohstoffListe
    {
        nahrung,
        gold,
        steine,
    }

    public enum Produktion {
        feld,
        mine,
        steinbruch,
    }

    
}


