﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace CSharpProjekt {
    public partial class KarteControl : UserControl {

        Karte karte;

        public Karte Karte {
            get { return karte; }
            set { karte = value; }
        }

        public KarteControl () {
            InitializeComponent ();

        }

        public void setVisibility (bool visible) {
            Kartenname.Visible = visible;
            Kartentext.Visible = visible;
            Kosten.Visible = visible;
            pictureBox1.Visible = visible;
            Art.Visible = visible;

            this.Refresh();
        }

        public void KarteZuweisen (Karte karte) {
            this.karte = karte;
            Kartenname.Text = karte.Name;
            Kartentext.Text = karte.FormatiereAttribute();
            Kosten.Text = karte.FormatiereKosten ();
            Art.Text = karte.Art;
            pictureBox1.Image = karte.Bild;
            setVisibility (true);
        }

        private void KarteControl_MouseClick(object sender, MouseEventArgs e) {
            KarteAusspielen();
        }

        private void KarteAusspielen() {
            if(KarteAusgespielt != null)
                KarteAusgespielt(this, new EventArgs());
        }

        public void KarteEntfernen() {
            setVisibility(false);
            Enabled = false;
            Karte = null;
        }

        public event EventHandler KarteAusgespielt;

        private void pictureBox1_Click(object sender, EventArgs e) {
            KarteControl_MouseClick(sender, e as MouseEventArgs);
        }

        private void Art_Click(object sender, EventArgs e) {
            KarteControl_MouseClick(sender, e as MouseEventArgs);
        }

        private void Kartenname_Click(object sender, EventArgs e) {
            KarteControl_MouseClick(sender, e as MouseEventArgs);
        }

        private void Kosten_Click(object sender, EventArgs e) {
            KarteControl_MouseClick(sender, e as MouseEventArgs);
        }

        private void Kartentext_Click(object sender, EventArgs e) {
            KarteControl_MouseClick(sender, e as MouseEventArgs);
        }
    }
}
