﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Drawing.Drawing2D;

///
/// WRITTEN BY FLORIAN RAPPL, 2011
/// CODE IS FREE TO USE -- CPOL [ Code Project Open License ]
/// 

namespace rsi.Controls.iToolTip
{
    public class DrawToolTipEventArgs : EventArgs
    {
        #region members

        Graphics graphics;
        Font font;
        Rectangle rect;
        Color foreColor;
        Color gradientColorOne;
        Color gradientColorTwo;
        object toolTip;

        #endregion

        #region ctor

        public DrawToolTipEventArgs(Graphics graphics, Font font, Rectangle rect, Color foreColor, Color gradientColorOne, Color gradientColorTwo, object toolTip)
        {
            this.gradientColorOne = gradientColorOne;
            this.gradientColorTwo = gradientColorTwo;
            this.graphics = graphics;
            this.font = font;
            this.rect = rect;
            this.foreColor = foreColor;
            this.toolTip = toolTip;
        }

        #endregion

        #region properties

        /// <summary>
        /// Gets the boundary where to draw
        /// </summary>
        public Rectangle Bounds { get { return rect; } }

        /// <summary>
        /// Gets the font that should be used
        /// </summary>
        public Font Font { get { return font; } }

        /// <summary>
        /// Gets the color that should be used
        /// </summary>
        public Color ForeColor { get { return foreColor; } }

        /// <summary>
        /// Gets the upper gradient color that should be used
        /// </summary>
        public Color GradientColorOne { get { return gradientColorOne; } }

        /// <summary>
        /// Gets the lower gradient color that should be used
        /// </summary>
        public Color GradientColorTwo { get { return gradientColorTwo; } }

        /// <summary>
        /// Gets the graphics object to actually draw something
        /// </summary>
        public Graphics Graphics { get { return graphics; } }

        /// <summary>
        /// Gets the tooltip (or loading, or exception) object (string?) to draw
        /// </summary>
        public object ToolTip { get { return toolTip; } }

        #endregion

        #region methods

        /// <summary>
        /// Draws the standard background (bubble)
        /// </summary>
        public virtual void DrawBackground()
        {
            LinearGradientBrush lgb = new LinearGradientBrush(rect, gradientColorOne, gradientColorTwo, LinearGradientMode.Vertical);

            //This draws the basic tooltip bubble
            GraphicsPath gp = new GraphicsPath();
            gp.AddArc(rect.Width - 9, 0, 8, 8, -90, 90);
            gp.AddLine(rect.Width - 1, 4, rect.Width - 1, rect.Height - 13);
            gp.AddArc(rect.Width - 9, rect.Height - 17, 8, 8, 0, 90);

            gp.AddLines(new Point[] {
                new Point(rect.Width - 5, rect.Height - 9), 
                new Point(rect.Width / 2 + 4, rect.Height - 9),
                new Point(rect.Width / 2, rect.Height - 1),
                new Point(rect.Width / 2 - 4, rect.Height - 9),
                new Point(4, rect.Height - 9)
            });

            gp.AddArc(0, rect.Height - 17, 8, 8, 90, 90);
            gp.AddLine(0, rect.Height - 13, 0, 4);
            gp.AddArc(0, 0, 8, 8, 180, 90);
            gp.AddLine(4, 0, rect.Width - 5, 0);
            graphics.FillPath(lgb, gp);
            graphics.DrawPath(Pens.SteelBlue, gp);
        }

        #endregion
    }
}
