﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Bib
{
    class Vektor
    {
        double[] values;

        public double[] Values
        {
            get { return values; }
            private set { values = value; }
        }

        public int Length 
        {
            get { return values.Length; }
        }

        public Vektor(int nElements)
        {
            values = new double[nElements];
        }

        public void SetElement(int index, double value)
        {
            if (index < 0)
                return;
            else if (index >= Length)
                return;

            values[index] = value;
        }

        /// <summary>
        /// Gibt alle Elemente zurück mit einem entsprechenden Index.
        /// </summary>
        /// <param name="indexKind">Art des Index</param>
        /// <returns>Array mit Elementen</returns>
        public double[] GetElements(Kind indexKind)
        {
            List<double> _val = new List<double>();

            for (int i = (int)indexKind; i < Length; i += 2)
                _val.Add(values[i]);

            return _val.ToArray();
        }

        public void Fill()
        {
            Random ran = new Random();

            for (int i = 0; i < Length; i++)
                values[i] = ran.NextDouble();
        }
        
        public override string ToString()
        {
            string s = string.Empty;

            for (int i = 0; i < Length; i++)
                s += string.Format("{0}:\t{1}\n", i, values[i]);

            return s;
        }
    }

    enum Kind
    {
        Even = 0,
        Odd = 1
    }
}
