﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Threading;

namespace Beispiel
{
    public partial class ThreadForm : Form
    {
        delegate void AddToListBox(int nr);

        AddToListBox justAddit;

        public ThreadForm()
        {
            InitializeComponent();
            justAddit = new AddToListBox(AddToMyBox);
        }

        private void button1_Click(object sender, EventArgs e)
        {
            Thread t = new Thread(new ThreadStart(SomeSleepSomeWork));
            t.Start();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            progressBar1.Value = 0;
            backgroundWorker1.RunWorkerAsync();
        }

        void AddToMyBox(int nr)
        {
            if (listBox1.InvokeRequired)
                listBox1.Invoke(justAddit, nr);
            else
                listBox1.Items.Add(nr);
        }

        void SomeSleepSomeWork()
        {
            for (int i = 0; i < 10; i++)
            {
                Thread.Sleep(500);
                AddToMyBox(i);
            }
        }

        private void backgroundWorker1_DoWork(object sender, DoWorkEventArgs e)
        {
            for (int i = 0; i < 10; i++)
            {
                Thread.Sleep(500);
                backgroundWorker1.ReportProgress(i * 10, i);
            }

            e.Result = true;
        }

        private void backgroundWorker1_ProgressChanged(object sender, ProgressChangedEventArgs e)
        {
            progressBar1.Value = e.ProgressPercentage;
            listBox1.Items.Add(e.UserState);
        }

        private void backgroundWorker1_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            progressBar1.Value = 100;
            MessageBox.Show("Das Ergebnis des Workers war: " + e.Result);
        }
    }
}
