﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Drawing;

namespace Beispiel
{
    class MyControl : Control
    {
        double start;
        double end;

        public double Start
        {
            get { return start; }
            set 
            { 
                start = value; 
                Refresh();
            }
        }

        public double End
        {
            get { return end; }
            set 
            {
                if (start > value)
                {
                    end = start;
                    Start = value;
                }
                else
                {
                    end = value;
                    Refresh(); 
                }
            }
        }

        public MyControl()
        {
            start = 0.0;
            end = Math.PI;
        }

        protected override void OnPaint(PaintEventArgs e)
        {
            Graphics g = e.Graphics;
            DrawTheSinus(g, new Size(Width, Height));
            base.OnPaint(e);
        }

        private void DrawTheSinus(Graphics g, Size size)
        {
            g.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.AntiAlias;
            int length = size.Width / 2;
            double dx = (end - start) / length;
            int factor = size.Height / 2;
            Point lastPoint = Point.Empty;
            Color c = Color.FromArgb(255, 124, 126, 60);
            Pen pen = new Pen(c, 0.5f);

            for (int i = 0; i < length; i++)
            {
                double value = Math.Sin(start + i * dx);
                int x = i * 2;
                int y = size.Height / 2 - (int)(factor * value);
                Point currentPoint = new Point(x,y);

                g.DrawEllipse(Pens.Red, x, y, 2, 2);


                if (i == 0)
                    lastPoint = currentPoint;
                else if (i % 100 == 0)
                {
                    g.DrawLine(pen, lastPoint, currentPoint);
                    lastPoint = currentPoint;
                }
            }
        }

        public void SaveTheSinus(string filename)
        {
            Bitmap b = new Bitmap(640, 480);
            Graphics g = Graphics.FromImage(b);

            DrawTheSinus(g, b.Size);
            b.Save(filename);
        }

        protected override void OnSizeChanged(EventArgs e)
        {
            Refresh();
        }
    }
}
