﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Beispiel
{
    public partial class Form1 : Form
    {
        const int BUTTON_HEIGHT = 45;

        public Form1()
        {
            InitializeComponent();
        }

        private void CreateButtons()
        {
            for (int i = 0; i < bttitles.Items.Count; i++)
            {
                Button bt = new Button();
                bt.Height = BUTTON_HEIGHT;
                bt.Width = groupBox1.Width - 20;

                Point p = new Point();
                p.X = 10;
                p.Y = 25 + i * (bt.Height + 5);
                bt.Location = p;

                bt.Text = bttitles.Items[i].ToString();
                bt.Click += new EventHandler(ButtonCallback);

                bt.Anchor = AnchorStyles.Top | AnchorStyles.Left | AnchorStyles.Right;
                groupBox1.Controls.Add(bt);
            }
        }

        void ButtonCallback(object sender, EventArgs e)
        {
            MessageBox.Show((sender as Button).Text);
        }

        private void button1_Click(object sender, EventArgs e)
        {
            groupBox1.Controls.Clear();
            CreateButtons();
        }

        private void bttext_TextChanged(object sender, EventArgs e)
        {
            btadd.Enabled = !bttext.Text.Equals(string.Empty);
        }

        private void btadd_Click(object sender, EventArgs e)
        {
            //bttitles.Items.Add(bttext.Text);
            //bttext.Text = string.Empty;

            myControl1.End = double.Parse(bttext.Text);
        }

        private void button2_Click(object sender, EventArgs e)
        {
            if (saveFileDialog1.ShowDialog() == DialogResult.OK)
            {
                myControl1.SaveTheSinus(saveFileDialog1.FileName);
            }
        }

        private void button3_Click(object sender, EventArgs e)
        {
            new SpiraleForm().Show();
        }

        private void button4_Click(object sender, EventArgs e)
        {
            new ThreadForm().ShowDialog();
        }
    }
}
