﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using System.Net;
using System.IO;

namespace Beispiel
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
                Process.Start(openFileDialog1.FileName);
        }

        private void button2_Click(object sender, EventArgs e)
        {
            new Processes().Show();
        }

        private void button3_Click(object sender, EventArgs e)
        {
            button3.Enabled = false;
            progressBar1.Visible = true;
            backgroundWorker1.RunWorkerAsync();   
        }

        void browserOpenClick(object sender, EventArgs e)
        {
            Button bt = sender as Button;
            string html = (bt.Tag as TextBox).Text;
            new MiniBrowser(html).Show();
        }

        void WebResponseHandler(IAsyncResult result)
        {
            if (InvokeRequired)
                Invoke(new AsyncCallback(WebResponseHandler), result);
            else
            {
                HttpWebRequest request = result.AsyncState as HttpWebRequest;
                WebResponse response = request.EndGetResponse(result);

                Stream s = response.GetResponseStream();
                byte[] content = new byte[response.ContentLength];
                s.Read(content, 0, content.Length);
                s.Close();
                response.Close();
                string html = new UTF8Encoding().GetString(content);
                CreateHTMLForm(html);
            }
        }

        private void CreateHTMLForm(string html)
        {
            Form f1 = new Form();
            TextBox tb = new TextBox();
            tb.Dock = DockStyle.Fill;
            tb.Multiline = true;
            tb.Text = html;
            tb.ScrollBars = ScrollBars.Vertical;
            f1.Controls.Add(tb);
            Button bt = new Button();
            bt.Text = "Seite in Browser öffnen";
            bt.Dock = DockStyle.Bottom;
            bt.Tag = tb;
            bt.Click += new EventHandler(browserOpenClick);
            f1.Controls.Add(bt);
            f1.ShowDialog();
        }

        private void backgroundWorker1_DoWork(object sender, DoWorkEventArgs e)
        {
            string url = "http://www.florian-rappl.de/";
            HttpWebRequest request = WebRequest.Create(url) as HttpWebRequest;
            IAsyncResult iar = request.BeginGetResponse(new AsyncCallback(WebResponseHandler), request);
        }

        private void backgroundWorker1_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            button3.Enabled = true;
            progressBar1.Visible = false;
        }
    }
}
