var globals = {}, idact = 0, idcount = 0, sortable = 0, focussection = false, store = window.localStorage;
$(document).ready(function () {
		Array.prototype.max = function () {
			return Math.max.apply(Math,this);
		}; 

		function build(v) { // Section und zugehörigen Menüpunkt aufbauen
			$('<section/>').attr({id:'s'+v.id,tabindex:v.id}).html(v.content).focusin(function () {
				focussection = true;
			}).hide().appendTo('article');
			
			$('<li/>').attr({id:v.id}).text(v.name).click(handlerli).appendTo('nav ul');
		}
		
		function save(id) {
			if(id != 0)
			{
				var data = {};
				data.id = id;
				data.modified = new Date();
				data.name = $(('li#'+id)).text();
				data.content = $(('section#s'+id)).html();
				store.setItem(id,JSON.stringify(data));
			}
		}
		function saveglobals() {
				globals.title = $('header').text();
				store.setItem(0,JSON.stringify(globals));
		}
		
		function savesort() {
			globals.sort = [];
			$('nav ul li').each(function () {
				globals.sort.push($(this).attr('id'));
			});
			saveglobals();
		}
		
		function savetoserver() {
			save(idact); // Vorher lokal speichern, da hieraus übertragen wird
			savesort();
			if(store.length)
			{
				$('#status').html('<img src="load.gif" title="in Arbeit..." alt="in Arbeit..."/>').slideDown();
				var serv = {};
				serv.send = 1; serv.data = []; serv.title = JSON.parse(store.getItem(0)).title;
				// Sortierung der einzelnen Seiten holen
				$(JSON.parse(store.getItem(0)).sort).each(function (i,v) {
					var sdata = JSON.parse(store.getItem(v));
					if(sdata != null)
					{
						sdata.modified = Math.round(new Date(sdata.modified).getTime()/1000); // Unix-Timestamp
						serv.data.push(sdata);
					}
				});
				$.ajax({
						url: 'ajax.php', 
						data: serv,
						cache: false, 
						dataType: 'json',
						type: 'POST',
						success: function(data) {
							if(data.status == "0") $('#status').html('Erfolgreich auf dem Server gespeichert').delay(4000).slideUp();
							else $('#status').text('Ein Fehler ist aufgetreten.').delay(10000).slideUp();
						},
						error: function(xhr, status, err) {
							$('#status').text('Ein Übertragungsfehler ist aufgetreten.').delay(10000).slideUp();
						}
				});
			}			
		}
		
		function handlerli () { //Clickhandler für Menüpunkt
			if($(this).attr('id') != idact)
			{
				save(idact);
				idact = $(this).attr('id');	
			}			
			
			$('nav ul li').attr({contenteditable:false});
			$(this).attr({contenteditable:true}).focus();
			$('section').attr({contenteditable:false}).hide();
			$(('section#s'+$(this).attr('id'))).attr({contenteditable:true}).show();
			focussection = false;
		}
		
		
		$('div[data-dialog=true]').attr({title:"Quick'n'Dirty Website Builder"});
		
		$('header').attr({contenteditable:true}).focusin(function () {
			focussection = false;
		}).focusout(function () {
			saveglobals();
		});
		
		$('#helpers #start').dialog({
			modal:true,
			width: 420,
			buttons: {
				"Neu beginnen" : function () {
					store.clear();
					$('#content').empty();
					$('nav ul').empty();
					$(this).dialog('close');
				},
				"Aus lokalem Speichern laden" : function () {
					if(store.length)
					{
						$('#status').html('<img src="load.gif" title="in Arbeit..." alt="in Arbeit..."/>').slideDown();
						$('#content').empty();
						$('nav ul').empty();
					
						// Sortierung der einzelnen Seiten holen
						var glo = JSON.parse(store.getItem(0));
						var sortarray = $(glo.sort).each(function (i,v) {
							var sdata = JSON.parse(store.getItem(v));
							if(sdata != null)
							{
								build(sdata);
							}
						});
						
						if(sortarray.length > 0) idcount = $.makeArray(sortarray).max();
						
						$('header').text(glo.title);
						$('#status').html('Aus lokalem Speicher laden ERFOLGREICH').delay(4000).slideUp();
					}
					$(this).dialog('close');
				},
				"Aus Server-DB laden" : function () {
					$('#status').html('<img src="load.gif" title="in Arbeit..." alt="in Arbeit..."/>').slideDown();
					store.clear();
					$('#content').empty();
					$('nav ul').empty();
					$.ajax({
						url: 'ajax.php', 
						data: {fetch:1},
						cache: false, 
						dataType: 'json',
						type: 'GET',
						success: function(data) {
							if(data.status == "0")
							{
								$('#status').text('Aus Server-DB laden ERFOLGREICH').delay(4000).slideUp();
								$(data.data).each(function (i,v) {				
									build(v);
									
									v.modified = new Date(v.modified_ts*1000);
									delete v.modified_ts; // im store nicht gebraucht.
									store.setItem(v.id,JSON.stringify(v));
									
									// max. ID bestimmen
									var temp = parseInt(v.id);
									if(temp > idcount) idcount = temp;
								});
								$('header').text(data.title);
								savesort();								
							}
							else $('#status').text('Ein Fehler ist aufgetreten.');
						},
						error: function(xhr, status, err) {
							$('#status').text('Ein Übertragungsfehler ist aufgetreten.').delay(10000).slideUp();
						}
					});
					$(this).dialog('close');
				}
		}});
		
		$('#helpers #menue button').button();
		$('#helpers #com button').button();
		
		$('#reset_text').dialog({
				autoOpen: false,
				modal: true,
				buttons: {
					"Ja": function() {
						store.clear();
						$('#content').empty();
						$('nav ul').empty();
						$('header').text('Meine Homepage');
						idact = 0; idcount = 0;
						$( this ).dialog('close');
						$('#start').dialog('open');
					},
					"Abbrechen": function() {
						$( this ).dialog('close');
					}
			}
		});
		$('#reset').button().click(function () {
			$('#reset_text').dialog('open');
		});
		
		
		$('#del_text').dialog({
				autoOpen: false,
				modal: true,
				buttons: {
					"Ja": function() {
						store.removeItem(idact);
						$(('nav ul li#'+idact)).remove();
						$(('section#s'+idact)).remove();
						idact = 0;
						$( this ).dialog('close');
					},
					"Abbrechen": function() {
						$( this ).dialog('close');
					}
			}
		});
		$('button#del').click(function () {
			if(idact != 0) $('#del_text').dialog('open');
			else $('#del_how').dialog({
				modal: true,
				buttons: {
					"Ok": function () {
						$(this).dialog('close');
					}
			}});
		});		
		
		$('nav ul').sortable({
			placeholder: "ui-state-highlight",
			stop: function () {
						savesort();
		}}).sortable('disable');		
		$('button#sortswitch').button().click(function () {
			if(sortable == 0)
			{
				$(this).addClass('sortswitch').button('refresh');
				sortable = 1;
				$('nav ul').css({cursor:'move'}).sortable('enable').find('li').unbind('click');
			}
			else
			{
				sortable = 0;
				$(this).removeClass('sortswitch').button('refresh');
				$('nav ul').css({cursor:''}).sortable('disable').find('li').click(handlerli);
			}
		});	
		
		$('div#com button').each(function () { // Commandbuttons für Contenteditable
			$(this).click(function () {
				if(focussection) //Stellt sicher, dass man nur <section> bearbeiten darf
				{
					var second = false, third = null;
					if($(this).attr('data-prompt') == "true")
					{
						/* 
						#
						# jQueryUI Dialog geht nicht, da dieser Fokus annimmmt
						# und Textmarkierung dabei aufhebt.
						# => derzeit nur klassischer Prompt
						#						
						if(target.attr('id') == "createLink") $('<input type="url" required=""/>').appendTo('#prompt-input');
						
						$('#prompt-text').text(target.attr('data-prompt-text')).parent().dialog({
							modal: true,
							buttons: {
								"Ok": function () {
									third = $('#prompt-input input').val();								document.execCommand(target.attr('id'),second,third);
									//Aufräumen
									$('#prompt-input').empty();
									$('#prompt-text').text('');
									$(this).dialog('close');
								},
								"Abbrechen": function () {
									$(this).dialog('close');
								}									
							}
						});*/
						var third = prompt($(this).attr('data-prompt-text'));
						if(third.length) document.execCommand($(this).attr('id'),second,third); // kein RegExp-Check, da Link ja auch intern sein kann (z.B. "../tollesbild.png" oder "include/dummymodul.php?forward=false";
					}
					else document.execCommand($(this).attr('id'),second,third);
				}
			});
		});
		$('button#savetoserver').click(savetoserver);
		$('button#new').click(function () {
			save(idact); // alte aktive ID abspeichern
			
			idact = ++idcount;
			$('article').append(
				$('<section/>').attr({id:'s'+idcount,tabindex:idcount}).text('section '+idcount).focusin(function () {
					focussection = true;
				})
			); // tabindex dabei, damit Fokus funktioniert
			$('<li/>').attr({id:idcount}).text('Neue Seite').click(handlerli).appendTo('nav ul').click(); // Autofokus auf Menüpunkt beim Klicken auf "Neue Seite erstellen" geht leider nicht, da kein form-Element
		});
		$(window).unload(function () {
			save(idact);
			savesort();
			//confirm('Speichern!?'); ## nicht nachfragen!
		});
});