google.load("feeds", "1");

//load static sites
function loadStaticContent(filename, callback) {
    $.ajax({
        url: settings.baseURL + filename,
        dataType: 'html',
        type: 'GET',
        success: function (html, status) {
            var container = $('#content');
            container.html(html);
        },
        error: function (xhr, status, err) {
            alert('Fehler in der Abfrage!');
        },
        complete: function () {
            $('<img>').attr('src', settings.baseURL + 'icons/li/112_RightArrowLong_Blue_32x42_72.png').prependTo($('#content > ul > li'));
            if (callback != undefined)
                callback();
        }
    });
}

//load other scripts
function loadScript(file) {
    $(document).append($('<script>').attr('src', file));
}

//load icons for the navigation
function initializeNavigation() {
    $('#home').click(function () { focusize($('#home')); animate(function (callback) {  loadStaticContent('home.html', callback); }); });
    $('#links').click(function () { focusize($('#links')); animate(function (callback) { loadStaticContent('links.html', callback); }); });
    $('#publications').click(function () { focusize($('#publications'));  animate(function (callback) {  loadPublications(callback); }); });
    $('#filebrowser').click(function () { focusize($('#filebrowser'));  animate(function (callback) {  loadFileBrowser(callback); }); });
    $('#settings').click(function () { focusize($('#settings')); animate(function (callback) { loadSettingsDialog(callback); }); });

    var imgSrc = settings.baseURL + 'icons/nav/';
    $('#home').prepend($('<img>').attr('src', imgSrc + 'FavoriteStar_48x48.png'));
    $('#links').prepend($('<img>').attr('src', imgSrc + '138_PushPin_48x48_72.png'));
    $('#publications').prepend($('<img>').attr('src', imgSrc + 'Book_Green_48x48.png'));
    $('#filebrowser').prepend($('<img>').attr('src', imgSrc + 'Stuffed_Folder.png'));
    $('#settings').prepend($('<img>').attr('src', imgSrc + 'Settings.png'));
}

$(document).ready(function () {
    google.setOnLoadCallback(function () {
        //provide functionality
        loadScript('loadSettings.js');
        loadScript('loadNewsTicker.js');
        loadScript('loadPublications.js');
        loadScript('loadFileBrowser.js');
        loadScript('animation.js');

        loadSettings();

        initializeNavigation();

        $('#home').click();

        fadeIn();
    });
});