//animate function call
function animate(func) {
    if (settings.animations) {
        var objectsToFade = $('.fading');
        var first = true; //without this workaround, every element of objectsToFade would call func()
        objectsToFade.fadeOut(settings.animationSpeed, 'linear', function () {
            if (first) {
                first = false;
                func(function () {
                    objectsToFade.fadeIn(settings.animationSpeed, 'linear');
                });
            }
        });
    }
    else {
        func();
    }
}

function fadeIn() {
    var objectsToFade = $('.loading');
    if (settings.animations) {
        objectsToFade.hide();
        objectsToFade.css('visibility', 'visible');
        objectsToFade.fadeIn(settings.animationSpeed, 'linear');
    }
    else {
        objectsToFade.css('visibility', 'visible');
    }
}

var focusize = function (navItem) {
    if (settings.animations) {
        $('#nav button').animate({ 'font-size': '120%' }, settings.animationSpeed)
        $(navItem).animate({ 'font-size': '150%' }, settings.animationSpeed);
    }
    else {
        $('#nav button').css('font-size', '120%')
        $(navItem).css('font-size', '150%');
    }
}
