function appendPublication(title, time, abstract, link) {
    var container = $('#content');
    var article = $('<article>').addClass('publication');
    article.append($('<h2>').text(title));
    article.append($('<time>').text(time));
    article.append($('<span>').text(abstract));
    article.append($('<a>').attr('href', link).text('read more'));
    article.appendTo(container);
}

//reads list of publications from inspire
function loadPublications(callback) {
    $('#content').html('');
    //weil ajax ja cross site nix zulässt
    var feed = new google.feeds.Feed('http://inspirehep.net/rss?ln=de&p=simon+mages');
    feed.load(function (result) {
        //load inspire hep results
        if (!result.error) {
            for (var i = 0; i < result.feed.entries.length; i++) {
                var entry = result.feed.entries[i];
                var d = new Date(entry.publishedDate);
                appendPublication(entry.title, "" + d.getDate() + "." + (d.getMonth() + 1) + "." + d.getFullYear(), entry.content, entry.link);
            }
        }
        //load homebrew
        appendPublication('Master Thesis: Hadronic Spectral Functions in the QCD Transition Region - Scale Setting and Anisotropy Parameters for Lattice QCD Simulations',
                '25.10.2011', ['This work covered important preparatory tasks for subsequent lattice QCD',
                'studies in full QCD on anisotropic lattices: tuning of the anisotropy, anisotropic smearing, quenched scaling study,',
                'Maximum Entropy Method, finite temperature spectral functions.',
                'This master thesis paved the way for combining anisotropic lattices with the',
                'Maximum Entropy Method for a study of full QCD at finite temperature in a',
                'successive research project.'].join(' '),
                settings.fileDirURL + 'masterarbeit.pdf');
        appendPublication('Bachelor Thesis: The Effective Electromagnetic Lagrangian in All Orders of the Magnetic Field and the Chiral Magnetic Effect',
                '24.9.2010',
                ['This bachelor thesis explored the possibility of expanding a gauge theory perturbatively,',
                'not in the full coupling constant for the field strength tensor, but',
                'instead effectively in the coupling constant for some of the gauge fields. In',
                'this way an expansion of the Lagrangian for weak electric fields but arbitrary',
                'magnetic fields is gained.',
                'The physical result of this work is that for any quantitative analysis of the',
                'CME one has to take into account the effects from strong field QED. Further',
                'research projects could be located in exploring non-constant fields to improve',
                'the estimations for the Chiral Magnetic Effect'].join(' '),
                settings.fileDirURL + 'thesis.pdf');
        appendPublication('Facharbeit: Neuere Erkenntnisse über die vielfältigen Funktionen von RNA-Molekülen',
                '21.1.2007',
                ['Als im Jahre 1869 der Schweizer Physiologe Friedrich Miescher seiner Entdeckung einer bislang unbekannten Substanz in Zellkernen den Namen „Nuclein“ gab, ahnte noch niemand etwas von der erstaunlichen Komplexität dieses Stoffes. Bald darauf erkannte man, dass das Nuclein über zwei Anteile verfügte, deren einer sich als gemeines Protein zu erkennen gab, deren anderer aber aus einer weiteren, jedoch sauren Substanz zu bestehen schien, der als Nucleinsäure bezeichnet wurde. Es stellte sich zudem heraus, dass sich die Nucleinsäure aus zwei chemisch verschiedenen Arten von Säuren zusammensetzte, die als Desoxyribonucleinsäure (DNA) und Ribonucleinsäure (RNA) bekannt wurden.',
                'Diese Arbeit beschäftigt sich mit der großen Bedeutung der RNA für ein breites Spektrum an zellulären Funktionen.',
                'Dabei werden Ergebnisse aktueller Forschung zu vielen Erscheinungsformen und Aspekten von RNA zusammengetragen:',
                'Aufbau der RNA, Messenger-RNA, Transfer-RNA, Ribosomale RNA, Ribozyme, Antisense RNA, RNA Interferenz,',
                'Small nuclear RNA, Small cytoplasmatic RNA, RNA-Viren, Proteinenzyme und RNA, medizinische und technische Anwendungen,',
                'weitere RNAs und RNA-Welt-Hypothese.'].join(' '),
                settings.fileDirURL + 'RNA.pdf');
        if (callback != undefined)
            callback();
    });
}