//contains all global variables
var settings = {};

//load setting from local storage
function loadSettings(callback) {
    //constant values
    settings.baseURL = document.location.href.split('/index.html')[0].split('/index')[0];
    if (settings.baseURL[settings.baseURL.length - 1] != '/')
        settings.baseURL += '/';
    settings.fileDirURL = 'http://homepages-nw.ur.de/~mas50900/';
    settings.animationSpeed = 500;

    //user defined values
    var temp;
    temp = localStorage.getItem('newsFeedURL')
    if (temp != null)
        settings.newsFeedURL = temp;
    else
        settings.newsFeedURL = 'http://rss.cnn.com/rss/cnn_latest.rss';
    temp = localStorage.getItem('animations')
    if (temp != null)
        settings.animations = temp == 'true';
    else
        settings.animations = true;

    loadNewsTicker(settings.newsFeedURL, callback);
}

//change settings
function loadSettingsDialog(callback) {
    $('#content').html('');
    loadStaticContent('settings.html');
    var loadrest = function () {
        if ($('#newsFeedURL')[0] == undefined) {
            //wait for static content to be parsed by the browser...
            setTimeout(loadrest, 100);
        }
        else {
            $('#newsFeedURL').val(settings.newsFeedURL);
            $('#enableAnimations')[0].checked = settings.animations;
            $('#saveSettings').click(function () {
                localStorage.setItem('newsFeedURL', $('#newsFeedURL').val());
                localStorage.setItem('animations', $('#enableAnimations')[0].checked);
                loadSettings();
            });
            $('#restoreSettings').click(function () {
                localStorage.clear();
                loadSettings();
                loadSettingsDialog();
            });
            styleSettings();
            if (callback != undefined)
                callback();
        }
    };
    loadrest();
}

//style settings
function styleSettings()
{
    var imgSrc = settings.baseURL + 'icons/settings/';
    $('#newsFeedURL').parent().prepend($('<img>').attr('src', imgSrc + 'base_rss.png'));
    $('#enableAnimations').parent().prepend($('<img>').attr('src', imgSrc + 'status_anim.gif'));
    $('#saveSettings').prepend($('<img>').attr('src', imgSrc + 'saveHS.png'));
    $('#restoreSettings').prepend($('<img>').attr('src', imgSrc + 'DeleteHS.png'));
}