﻿$(function() {
	var spielaktiv = false;
	
	//Die Standardoptionen
	var rechterspieler = "Rechts";
	var linkerspieler = "Links";
	
	var gewinnsätze = 2;
	var satzpunkte = 25;
	
	//Das Canvascontextobjekt fürs Zeichnen
	var canvascontext;
	
	//Der rechte Blobby
	var rblobby;
	
	//Der linke Blobby
	var lblobby;
	
	//Der Ball
	var ball;
	
	//Wird gerade gespielt oder ist das Spiel in der Standardposition
	var start = false;
		
	//Legt fest ob gerade pausiert ist
	var pause = false;
	var pausenzähler = 0;
	
	$("#spielmenu").css("display", "block");
	$("#spieloptionen").css("display", "none");
	$("#spielfeld").css("display", "none");
	$("#sieganzeige").css("display", "none");
	$("#spielabbruch").css("display", "none");
	
	//Ereignisse setzen
	$("#startbutton").click(function()
	{ 
		spielaktiv = true;
		
		$("#spielmenu").css("display", "none");
		$("#spielfeld").css("display", "block");
		
		$("#linkerspieler").html(linkerspieler);
		$("#rechterspieler").html(rechterspieler);
		
		var canvas = document.getElementById("canvas");
		canvascontext = canvas.getContext("2d");
		
		refresh();
		
		rblobby = new Blobby("rechts");
		lblobby = new Blobby("links");
		ball = new Ball(rblobby, lblobby);
		
		$("#punktestand").html("(" + 0 + ") " + 0 + " : " + 0 + " (" + 0 + ")");
	});
	
	$("#optionbutton").click(function()
	{ 
		$("#spielmenu").css("display", "none");
		$("#spieloptionen").css("display", "block");
	});
	
	$("#optionokbutton").click(function()
	{ 
		var validated = true;
		
		linkerspieler = $("#namelinks").val();
		rechterspieler = $("#namerechts").val();
		
		gewinnsätze = $("#satzinput").val();
		satzpunkte = $("#punktinput").val();
		
		if (isNaN(gewinnsätze) || gewinnsätze < 1 || gewinnsätze > 3) 
		{
			alert("Bitte überprüfe deine Eingabe für die Gewinnsätze. Sie sollte zwischen 1 und 3 liegen.");
			validated = false;
		}
		if (isNaN(satzpunkte) || satzpunkte < 5 || gewinnsätze > 25) 
		{
			alert("Bitte überprüfe deine Eingabe für die Satzpunkte. Sie sollte zwischen 5 und 25 liegen.");
			validated = false;
		}
		
		if (validated) 
		{
			$("#spielmenu").css("display", "block");
			$("#spieloptionen").css("display", "none");
		}
	});
	
	$("#siegokbutton").click(function()
	{ 
		$("#spielmenu").css("display", "block");
		$("#sieganzeige").css("display", "none");
	});
	
	$("#abbruchja").click(function()
	{ 
		$("#spielmenu").css("display", "block");
		$("#spielabbruch").css("display", "none");
	});
	
	$("#abbruchnein").click(function()
	{ 
		$("#spielfeld").css("display", "block");
		$("#spielabbruch").css("display", "none");
		
		spielaktiv = true;
	});
	
	//Verschiedene Konstanten
		//Die Erdbeschleunigung
		var erdbeschl = 0.001875;
		
		//Seitliche Geschwindigkeit der Blobbys
		var deltax = 0.4;
		
		//Sprunggeschwindigkeit der Blobbys
		var maxdeltay = 1.05;
		
		//Wie stark wird der Ball durch den Blobby beschleunigt
		var schubkraft = 0.4;
		
		//Wie stark prallt der Ball vom Blobby ab ("Elastischer" Stoß)
		var stoßkraft = 0.8;
		
		//Reibung des Balls
		var reibung = 1;
		
		//Luftreibung des Balls für "Bananenkurve"
		var luftreibung = 0.005;
		
		//Starthöhe des Balls
		var starty = 250;
		
		//Die Framerate des Spiels in ms
		var framerate = 30;
		
		//Pausenzeit nach beendetem Punkt in Frames
		var pausenzeit = 15;
	
	setInterval(function() {
		if (spielaktiv && !pause)
		{	
			for (var i = framerate; i--; )
			{
				rblobby.bewegen();
				lblobby.bewegen();
				ball.bewegen();
			}
			
			refresh();
			rblobby.zeichnen();
			lblobby.zeichnen();				
			ball.zeichnen();
		}
		else if (pause)
		{
			pausenzähler++;
			if (pausenzähler == pausenzeit)
			{
				pause = false;
				pausenzähler = 0;
			}
		}
	}, framerate);
	
	var keypress = function(event) {
		if (spielaktiv && !pause)
		{
			var up = event.type === 'keyup';
			
			switch (event.keyCode) {
				case 27://Escape Taste
					if (!start)
					{
						$("#spielfeld").css("display", "none");
						$("#spielabbruch").css("display", "block");
						
						spielaktiv = false;
					}
					break;
				case 65://a Taste
					lblobby.links(up);
					break;
				case 68://d Taste
					lblobby.rechts(up);
					break;
				case 87://w Taste
					lblobby.spring(up);
					break;
				case 37://Pfeil links
					rblobby.links(up);
					break;
				case 39://Pfeil rechts
					rblobby.rechts(up);
					break;
				case 38://Pfeil hoch
					rblobby.spring(up);
					break;
				case 40://Pfeil runter
					break;
				default:
					return true;
			}
			
			event.preventDefault();
			return false;
		}
	};

	$('html').bind('keydown', keypress);
	$('html').bind('keyup', keypress);
	
	refresh = function()
	{	
		canvascontext.lineWidth = 1;
		canvascontext.strokeStyle = "#000000";
		canvascontext.clearRect(0, 0, 1000, 600);
		
		//Der Mittelpfosten bzw. das Netz
		canvascontext.fillStyle = "#999999";
		
		canvascontext.beginPath();
		canvascontext.arc(500, 310, 10, 0, 1 * Math.PI, true);
		canvascontext.lineTo(490, 600);
		canvascontext.lineTo(510, 600);
		canvascontext.lineTo(510, 310);
		
		canvascontext.fill();
		canvascontext.stroke();
	}
	
	//Die Blobby-Klasse
	function Blobby(seite)
		{
		this.seite = seite;
		
		//Die Größe des Blobbys
		this.radius = 50;
		
		//Zeichnen
		canvascontext.beginPath();
		
		if (seite === "links") canvascontext.fillStyle = "#FF0000";
		else canvascontext.fillStyle = "#00FF00";
		
		canvascontext.arc(this.x, 600 - this.y, this.radius, 0, 2*Math.PI, true);
		canvascontext.fill();
		canvascontext.stroke();
		
		//Koordinaten des Blobbys
		this.x = 250;
		if (seite === "rechts") this.x = 750;
		
		this.y = this.radius;
		
		//Seitliche Bewegung des Blobby
		this.vx = 0;
		
		this.links = function(up)
		{
			this.vx = 0;
			
			if (!up) this.vx = -deltax;
		}
		
		this.rechts = function(up)
		{
			this.vx = 0;
			
			if (!up) this.vx = deltax;
		}
		
		//Springen des Blobbys
		this.vy = 0;
		
		this.springt = false;
		var springzähler = 0;
		
		this.spring = function(up)
		{
			if (!up && !this.springt)
			{
				this.springt = true;				
				this.vy = maxdeltay + erdbeschl;
			}
		}
		
		//Bewegen des Blobbys
		
		this.bewegen = function()
		{
			if (this.springt)
			{
				this.vy -= erdbeschl;
				if (this.y < this.radius)
				{
					this.springt = false;
					this.vy = 0;
					this.y = this.radius;
				}
			}
			
			if (this.vx < 0)
			{
				if (seite === "links")
				{
					if (this.x > (this.radius-1+deltax))
					{
						this.x += this.vx;
					}
				}
				else
				{
					if (this.x > (509+this.radius+deltax))
					{
						this.x += this.vx;
					}
				}
			}
			else if (this.vx > 0)
			{
				if (seite === "links")
				{
					if (this.x < (491-this.radius-deltax))
					{
						this.x += this.vx;
					}
				}
				else
				{
					if (this.x < (1001-this.radius-deltax))
					{
						this.x += this.vx;
					}
				}
			}
						
			this.y += this.vy;
		}
		
		this.zeichnen = function()
		{
			canvascontext.beginPath();
				
			if (seite === "links") canvascontext.fillStyle = "#FF0000";
			else canvascontext.fillStyle = "#00FF00";
			
			canvascontext.arc(this.x, 600 - this.y, this.radius, 0, 2*Math.PI, true);
			canvascontext.fill();
			canvascontext.stroke();
		}
		
		//Gibt an, ob sich der Ball mit diesem Blobby gerade überschneidet (keine doppelten Stöße)
		this.balldrin = false;
		
		//Gibt an, wie oft der Ball bereits gespielt wurde
		this.balltreffer = 0;
		
		//Punkte und Sätze
		this.punkte = 0;
		this.sätze = 0;	
	}
	
	//Die Ball-Klasse
	function Ball(rb, lb)
	{
		//Größe des Balls
		this.radius = 50;
		
		//Koordinaten und Geschwindigkeiten
		this.x = 750;
		this.y = starty;
		this.vx = 0;
		this.vy = 0;
		
		//Winkelgeschwindigkeit (Vektor am obersten Punkt des Balls in positive x-Richtung)
		this.omega = 0;
		
		//Zeichnen
		var ballImg = document.getElementById("ballimg");
		ballImg.src = 'bilder/ball.png';
		
		var ballcanvas = document.createElement('canvas');
		ballcanvas.width = 100;
		ballcanvas.height = 100;
		
		var b = ballcanvas.getContext('2d');
		b.translate(50, 50);
		
		b.drawImage(ballImg, 0, 0, ballImg.width, ballImg.height, -50, -50, 100, 100);
		canvascontext.drawImage(b.canvas, this.x - 50, 550 - this.y);
		
		this.bewegen = function()
		{
			//Überprüfung, ob die Wand berührt wird
			if (this.x <= this.radius)
			{
				this.vx *= -1;
				this.vy += this.omega;
			}
			else if (this.x >= 1000 - this.radius)
			{
				this.vx *= -1;
				this.vy -= this.omega;
			}
			//Überprüfung, ob das Netz berührt wird
			var abstandx = ball.x - 500;
			var abstandy = ball.y - 290;
			var abstand = (Math.pow(abstandx, 2) + Math.pow(abstandy, 2));
			
			if (this.vx >= 0 && this.y <= 300 && this.x >= 490 - this.radius && this.x <= 510) 
			{
				this.vx *= -1;
				this.vy -= this.omega;
			}
			else if (this.vx <= 0 && this.y <= 300 && this.x <= 510 + this.radius && this.x >= 490)
			{
				this.vx *= -1;
				this.vy += this.omega;
			}
			else if (abstand <= Math.pow(ball.radius + 10, 2))
				{				
				//Zwischenspeichern
				var ballvx = ball.vx;
				var ballvy = ball.vy;
				var ballomega = ball.omega;
				
				//Elastischer Stoß an der Netzkante
				var abstandskalarball = abstandx * ballvx + abstandy * ballvy;
				
				if (abstandskalarball < 0)
				{
					if (abstandx !== 0)
					{
						var alpha = abstandy / abstandx;
						var alphaquad = Math.pow(alpha, 2);
						
						var det = (alpha * ballvx - ballvy) / (1 + alphaquad);			
						var rest = (-alpha * (ballvx + ballvy * alpha)) / (1 + alphaquad);						
						
						var neuvy = rest + det;	
						if (parseInt(neuvy * 1000) === parseInt(-ballvy * 1000)) neuvy = rest - det;
						
						ball.vx = (-1) * (ballvx + alpha * (ballvy + neuvy));
						ball.vy = neuvy;
					}
					else ball.vy = (-1) * ballvy;
					
					//Abrutschen des Balls durch den Spin
					if (ballomega !== 0)
					{
						ball.vx += (reibung * ballomega * abstandy) / abstand;
						ball.vy += ((-1) * reibung * ballomega * abstandx) / abstand;
					}
					
					//Spin durch Ball
					var spinballvx = ballvx + ((abstandx * abstandskalarball) / abstand);
					var spinballvy = ballvy + ((abstandy * abstandskalarball) / abstand);
					
					ball.omega += ((spinballvx * abstandy) - (spinballvx * abstandx)) / abstand;
				}
			}
			if (this.omega !== 0)
			{
				var ballvgesamt = Math.sqrt(Math.pow(ball.vx, 2) + Math.pow(ball.vy, 2));
				var ballchangex = (ball.vy * this.omega * luftreibung) / ballvgesamt;
				var ballchangey = (-ball.vx * this.omega * luftreibung) / ballvgesamt;
				
				ball.vx += ballchangex;
				ball.vy += ballchangey;
			}
			
			kontrolle(rb, this, lb);
			kontrolle(lb, this, rb);
			
			this.x += this.vx;
			this.y += this.vy;
			
			if (start)
				this.vy -= erdbeschl;
				
			if (this.y <= this.radius)
			{
				if (this.x < 500) restart(rb, lb, this);
				else restart(lb, rb, this);
			}
		}
		
		this.zeichnen = function()
		{			
			if (start)
			{
				b.rotate(-Math.PI * this.omega * framerate * 5/ this.radius);
			}
			b.drawImage(ballImg, 0, 0, ballImg.width, ballImg.height, -50, -50, 100, 100);
			canvascontext.drawImage(b.canvas, this.x - 50, 550 - this.y);
		}
		
		//Kontrolle, ob der Ball an etwas stößt
		function kontrolle(blobby, ball, blobby2)
		{
			var abstandx = ball.x - blobby.x;
			var abstandy = ball.y - blobby.y;
			
			var abstand = Math.pow(abstandx, 2) + Math.pow(abstandy, 2);
			var abstandklein = abstand <= Math.pow(ball.radius + blobby.radius, 2);
			
			if (!blobby.balldrin && abstandklein)
			{
				blobby2.balltreffer = 0;
				blobby.balltreffer += 1;
				
				if (blobby.balltreffer == 4)
				{
					restart(blobby2, blobby, ball);
					return;
				}
					
				blobby.balldrin = true;
				
				//Zwischenspeichern
				var ballvx = ball.vx;
				var ballvy = ball.vy;
				var ballomega = ball.omega;
								
				//"Elastischer" Stoß am Blobby
				var abstandskalarball = abstandx * ballvx + abstandy * ballvy;
								
				if (abstandskalarball < 0)
				{
					if (abstandx !== 0)
					{
						var alpha = abstandy / abstandx;
						var alphaquad = Math.pow(alpha, 2);
						
						var det = (alpha * ballvx - ballvy) / (1 + alphaquad);			
						var rest = (-alpha * (ballvx + ballvy * alpha)) / (1 + alphaquad);						
						
						var neuvy = rest + det;	
						if (parseInt(neuvy * 1000) === parseInt(-ballvy * 1000)) neuvy = rest - det;
						
						ball.vx = (-1) * (ballvx + alpha * (ballvy + neuvy)) * stoßkraft;
						ball.vy = neuvy * stoßkraft;
					}
					else ball.vy = (-1) * ball.vy * stoßkraft;
					
					//Spin durch Ball
					var spinballvx = ballvx + ((abstandx * abstandskalarball) / abstand);
					var spinballvy = ballvy + ((abstandy * abstandskalarball) / abstand);
					
					ball.omega += ((spinballvx * abstandy) - (spinballvx * abstandx)) / abstand;
				}
				
				//Schub durch den Blobby
				var abstandskalarblobby = abstandx * blobby.vx + abstandy * blobby.vy;
				
				if (abstandskalarblobby > 0)
				{
					var blobbyskalarstoß = schubkraft * (blobby.vx * abstandx + blobby.vy * abstandy) / (Math.pow(abstandx, 2) + Math.pow(abstandy, 2));
					
					if (!start) blobbyskalarstoß *= 1.5 / schubkraft;
					
					ball.vx += abstandx * blobbyskalarstoß;
					ball.vy += abstandy * blobbyskalarstoß;
					
					var spinblobbyvx = blobby.vx - ((abstandx * abstandskalarblobby) / abstand);
					var spinblobbyvy = blobby.vy - ((abstandy * abstandskalarblobby) / abstand);
						
					ball.omega += ((spinblobbyvx * abstandy) - (spinblobbyvy * abstandx)) / abstand;
				}
				
				//Abrutschen des Balls durch den Spin
				if (ball.omega !== 0)
				{
					ball.vx += (reibung * ballomega * abstandy) / abstand;
					ball.vy += ((-1) * reibung * ballomega * abstandx) / abstand;
				}

				//Starten des Punkts
				if (!start) start = true;
			}
			else if (!abstandklein && blobby.balldrin) blobby.balldrin = false;
		}
		
		function restart(winblobby, loseblobby, ball)
		{
			start = false;
			pause = true;
			
			winblobby.punkte += 1;
			
			if (winblobby.punkte >= satzpunkte && winblobby.punkte - loseblobby.punkte > 1)
			{
				winblobby.sätze += 1;
				
				winblobby.punkte = 0;
				loseblobby.punkte = 0;
				
				if (winblobby.sätze == gewinnsätze)
				{
					spielaktiv = false;
					
					$("#spielfeld").css("display", "none");
					$("#sieganzeige").css("display", "block");
					
					if (winblobby.seite === "links")	$("#siegerspan").html(linkerspieler);
					else $("#siegerspan").html(rechterspieler)
				}
			}
			
			if (winblobby.seite === "links")
			{
				winblobby.x = 250;		
				loseblobby.x = 750;	

				$("#punktestand").html("(" + winblobby.sätze + ") " + winblobby.punkte + " : " + loseblobby.punkte + " (" + loseblobby.sätze + ")");
			}
			else
			{
				winblobby.x = 750;				
				loseblobby.x = 250;

				$("#punktestand").html("(" + loseblobby.sätze + ") " + loseblobby.punkte + " : " + winblobby.punkte + " (" + winblobby.sätze + ")");
			}
			
			winblobby.y = winblobby.radius;
			winblobby.vx = 0;
			winblobby.vy = 0;
			winblobby.springt = false;
			
			loseblobby.y = loseblobby.radius;
			loseblobby.vx = 0;
			loseblobby.vy = 0;
			loseblobby.springt = false;
			
			ball.x = winblobby.x;
			ball.y = starty;
			ball.vx = 0;
			ball.vy = 0;
			ball.omega = 0;
			
			winblobby.balltreffer = 0;
			loseblobby.balltreffer = 0;
		}
	}
});