﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Malefiz
{
    public struct Figurennummerierung
    {
        /// <summary>
        /// Die Spielernummer dieser Figur: 
        /// 0: Roter Spieler
        /// 1: Grüner Spieler
        /// 2: Gelber Spieler
        /// 3: Blauer Spieler
        /// </summary>
        public int SpielerNummer { get; set; }

        /// <summary>
        /// Die Figurnummer dieser Figur:
        /// 0: Figur 1 ... 4: Figur 5
        /// </summary>
        public int FigurenNummer { get; set; }

        //public Figurennummerierung()
        //{ }

        /// <summary>
        /// In einer Instanz dieser Klasse soll die Figurennummerierung gespeichert werden.
        /// </summary>
        /// <param name="spieler">Die Spielernummer der Figur, die das Feld aktuell belegt: 
        /// 0: Roter Spieler
        /// 1: Grüner Spieler
        /// 2: Gelber Spieler
        /// 3: Blauer Spieler</param>
        /// <param name="figur">Die Figurnummer der Figur, die das Feld aktuell belegt:
        /// 0: Figur 1 ... 4: Figur 5</param>
        public Figurennummerierung(int spieler, int figur) : this()
        {
            SpielerNummer = spieler;
            FigurenNummer = figur;
        }
    }
}