﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Malefiz.Klassen_für_Spielbrett;

namespace Malefiz
{
    class Spielbrett
    {
        //======================//
        //Variablendeklarationen//
        //======================//

        /// <summary>
        /// In diesem Array sind die vier Spieler gespeichert, die an dem Spiel teilnehmen.
        /// Indizierung:
        /// 0: Roter Spieler
        /// 1: Grüner Spieler
        /// 2: Gelber Spieler
        /// 3: Blauer Spieler
        /// </summary>
        public Spieler[] spielerpool = new Spieler[4];

        //private Spieler[] kopie_spielerpool = new Spieler[4];

        /// <summary>
        /// In diesem 2D-Array sind alle 14*17 Spielfelder gespeichert, die zur Initialisierung 
        /// eines Spielbrettes erstellt werden (auch die toten Spielfelder).
        /// Indizierung: 
        /// [x][y] === 
        /// [x] x-Koordinate des Spielfeldes von 0 bis 16 === 
        /// [y] y-Koordinate des Spielfeldes von 0 bis 13
        /// </summary>
        public Feld[][] felderpool = new Feld[17][];

        //private Feld[][] kopie_felderpool = new Feld[17][];

        /// <summary>
        /// In diesem 2D-Array sind alle Spielfiguren von allen Spielern gespeichert, die an diesem 
        /// Spiel teilnehmen. 
        /// Indizierung: 
        /// [Spielernumme][Figurennummer] === 
        /// [Spielernummer] 0: Spielfigur des roten Spielers ... 3: Spielfigur des blauen Spielers === 
        /// [Figurennummer] 0: Erste Spielfigur ... 4: Fünfte Spielfigur
        /// </summary>
        public Figur[][] figurenpool = new Figur[4][];

        //private Figur[][] kopie_figurenpool = new Figur[4][];

        /// <summary>
        /// In diesem Array sind alle Barrikaden gespeichert, die an diesem Spiel teilnehmen. 
        /// Indizierung: 
        /// [Barrikadennummer] 0: Barrikade 1 ... 10: Barrikade 11
        /// </summary>
        public Barrikade[] barrikadenpool = new Barrikade[11];

        //private Barrikade[] kopie_barrikadenpool = new Barrikade[11];

        /// <summary>
        /// In diesem 2D-Array sind alle Hausfelder gespeichert, die es in diesem Spiel gibt. 
        /// Indizierung: 
        /// [Spielernummer][Figurennummer] === 
        /// [Spielernummer] 0: Hausfeld des roten Spielers ... 3: Hausfeld des blauen Spielers === 
        /// [Figurennummer] 0: Hausfeld der erstne Spielfigur ... 4: Hausfeld der fünften Spielfigur
        /// </summary>
        public Haus[][] häuserpool = new Haus[4][];

        //private Haus[][] kopie_häuserpool = new Haus[4][];

        Würfel dice;
        int augenzahl;
        int werIstDran;
        int nochZuGehen;
        Feldposition letztesFeld;
        Figur figurVorZug;
        Figur ÜbersprungeneFigur;
        bool wurdeFigurÜbersprungen;
        bool mussteZugZurücksetzen;
        bool zieheMitNeuerFigur;
        bool ende;

        public bool ZieheMitNeuerFigur
        {
            get { return zieheMitNeuerFigur; }
            set { zieheMitNeuerFigur = value; }
        }

        public Figur FigurVorZug
        {
            get { return figurVorZug; }
            set { figurVorZug = value; }
        }

        /// <summary>
        /// Soll auf true gestellt werden, wenn es nötig war den Zug zurückzusetzen.
        /// </summary>
        public bool MussteZugZurücksetzen
        {
            get { return mussteZugZurücksetzen; }
            set { mussteZugZurücksetzen = value; }
        }

        /// <summary>
        /// Speichert das letzte Feld der Figur um zu verhindern, dass der Spieler auf zwei Feldern "hin- und herzieht".
        /// </summary>
        public Feldposition LetztesFeld
        {
            get { return letztesFeld; }
            set { letztesFeld = value; }
        }

        /// <summary>
        /// In dieser Eigenschaft kann abgefragt werden, ob das Spiel durch den Sieg eines Spielers beendet wurde.
        /// </summary>
        public bool Ende
        {
            get { return ende; }
        }

        /// <summary>
        /// In dieser Eigenschaft ist der Würfel des Spielfeldes gespeichert. Über seine Methode Würfeln() 
        /// kann dieser eine Zufallszahl zwischen 1 und 6 direkt in die Eigenschaften Augenzahl und NochZuGehen 
        /// dieses Spielbrettes schreiben.
        /// </summary>
        public Würfel Dice
        {
            get { return dice; }
            set { dice = value; }
        }

        ///// <summary>
        ///// In dieser Eigenschaft soll die Figur gespeichert werden, die vom Benutzer für den Zug ausgewählt wurde, wie sie vor dem Zug war. 
        ///// Falls sich herausstellt, dass der Zug nicht möglich ist, soll die ausgewählte Figur zurück gesetzt werden, 
        ///// damit der Benutzer erneut ziehen kann.
        ///// </summary>
        //public Figur FigurVorZug
        //{
        //    get { return figurVorZug; }
        //    set { figurVorZug = value; }
        //}
        
        /// <summary>
        /// In dieser Eigenschaft wird gespeichert, wie viele Züge der Benutzer mit seiner Figur noch ziehen muss. 
        /// Sobald er mit seiner Figur ein weiteres Feld vorrückt, soll diese int-Zahl um eins erniedrigt werden. 
        /// Ist diese int-Zahl 0, so bedeutet das, dass der Zug des aktuellen Benutzers beendet ist.
        /// </summary>
        public int NochZuGehen
        {
          get { return nochZuGehen; }
          set { nochZuGehen = value; }
        }

        /// <summary>
        /// In dieser Eigenschaft ist die Spielernummer des Spielers gespeichert, der gerade an der Reihe ist. 
        /// Um den nächsten Spieler auszuwählen genügt es (auch vom 4. Spieler auf den 1. Spieler), 
        /// diese int-Zahl um eins zu erhöhen. 
        /// Spielernummer: 
        /// 0: Roter Spieler
        /// 1: Grüner Spieler
        /// 2: Gelber Spieler
        /// 3: Blauer Spieler
        /// </summary>
        public int WerIstDran
        {
            get { return werIstDran; }
            set 
            {
                if (value == 4)
                { werIstDran = 0; }
                else
                    werIstDran = value; 
            }
        }

        /// <summary>
        /// In dieser Eigenschaft ist gespeichert, welche Augenzahl der Spieler in dieser Runde gewürfelt hat.
        /// </summary>
        public int Augenzahl
        {
            get { return augenzahl; }
            set { augenzahl = value; }
        }

        int x_vorZug, y_vorZug, figurnummer_vorZug, spielernummer_vorZug, letztes_x, letztes_y;
        Figurennummerierung übersprungen_nummerierung, ausgewählt;
        Feldposition übersprungen_position;



        //=============//
        //Konstruktoren//
        //=============//

        public Spielbrett()
        {
            dice = new Würfel(this);
            ende = false;
        }

        /// <summary>
        /// Erstellt ein neues Spielbrett. Dadurch werden automatisch alle Spieler, Spielfelder, Figuren, 
        /// Barrikaden und Hausfelder erstellt, die an diesem Spiel teilnehmen. Zudem werden alle Spielfiguren 
        /// auf ihren Ausgangspunkt gesetzt.
        /// </summary>
        /// <param name="ErsterSpieler">Name des roten Spielers</param>
        /// <param name="ZweiterSpieler">Name des grünen Spielers</param>
        /// <param name="DritterSpieler">Name des gelben Spielers</param>
        /// <param name="VierterSpieler">Name des blauen Spielers</param>
        public Spielbrett(string ErsterSpieler, string ZweiterSpieler, string DritterSpieler, string VierterSpieler) : this()
        {
            //Spieler erstellen
            Spieler spieler1 = new Spieler(ErsterSpieler, 0);
            spielerpool[0] = spieler1;
            Spieler spieler2 = new Spieler(ZweiterSpieler, 1);
            spielerpool[1] = spieler2;
            Spieler spieler3 = new Spieler(DritterSpieler, 2);
            spielerpool[2] = spieler3;
            Spieler spieler4 = new Spieler(VierterSpieler, 3);
            spielerpool[3] = spieler4;

            //Spielfelder erstellen
            for (int x = 0; x < 17; x++)
            {
                Feld[] feldarr = new Feld[14];
                felderpool[x] = feldarr;
            }
            
            for (int x = 0; x < 17; x++)
            {
                for (int y = 0; y < 14; y++)
                {
                    //Erzeuge komplettes Schachbrett mit toten Feldern
                    Feld feld = new Feld(x, y);

                    //Und Gott sprach, es werde Licht...
                    if (y == 0)
                    { feld.Gott();}
                    if (y == 2)
                    { feld.Gott();}
                    if (y == 10)
                    { feld.Gott();}
                    if (y == 12)
                    { feld.Gott();}
                    if (y == 4 && x >= 2 && x <= 14)
                    { feld.Gott();}
                    if (y == 6 && x >= 4 && x <= 12)
                    { feld.Gott();}
                    if (y == 8 && x >= 6 && x <= 10)
                    { feld.Gott();}
                    if (y == 1 && (x == 0 || x == 4 || x == 8 || x == 12 || x == 16))
                    { feld.Gott();}
                    if (y == 3 && (x == 2 || x == 6 || x == 10 || x == 14))
                    { feld.Gott();}
                    if (y == 5 && (x == 4 || x == 12))
                    { feld.Gott();}
                    if (y == 7 && (x == 6 || x == 10))
                    { feld.Gott();}
                    if (y == 11 && (x == 0 || x == 16))
                    { feld.Gott();}
                    if (y == 9 && x == 8)
                    { feld.Gott();}
                    if (y == 13 && x == 8)
                    { feld.Gott();}

                    //Felder auf denen am Anfang die Barrikaden stehen, müssen blockiert werden.
                    if (x == 0 && y == 2)
                    { feld.IstBlockiert = true; feld.Barrikadennummer = 0;}
                    if (x == 4 && y == 2)
                    { feld.IstBlockiert = true; feld.Barrikadennummer = 1;}
                    if (x == 8 && y == 2)
                    { feld.IstBlockiert = true; feld.Barrikadennummer = 2;}
                    if (x == 12 && y == 2)
                    { feld.IstBlockiert = true; feld.Barrikadennummer = 3;}
                    if (x == 16 && y == 2)
                    { feld.IstBlockiert = true; feld.Barrikadennummer = 4;}
                    if (x == 6 && y == 6)
                    { feld.IstBlockiert = true; feld.Barrikadennummer = 5;}
                    if (x == 10 && y == 6)
                    { feld.IstBlockiert = true; feld.Barrikadennummer = 6;}
                    if (x == 8 && y == 8)
                    { feld.IstBlockiert = true; feld.Barrikadennummer = 7;}
                    if (x == 8 && y == 9)
                    { feld.IstBlockiert = true; feld.Barrikadennummer = 8;}
                    if (x == 8 && y == 10)
                    { feld.IstBlockiert = true; feld.Barrikadennummer = 9;}
                    if (x == 8 && y == 12)
                    { feld.IstBlockiert = true; feld.Barrikadennummer = 10;}

                    felderpool[x][y] = feld;
                }
            }

            //Figuren erstellen
            for (int _Spielernummer = 0; _Spielernummer < 4; _Spielernummer++)
            {
                Figur[] figarr = new Figur[5];
                figurenpool[_Spielernummer] = figarr;
            }

            for (int _Spielernummer = 0; _Spielernummer < 4; _Spielernummer++)
            {
                for (int _Figurennummer = 0; _Figurennummer < 5; _Figurennummer++)
                {
                    Figur figur = new Figur(_Spielernummer, _Figurennummer);
                    figurenpool[_Spielernummer][_Figurennummer] = figur;
                }
            }

            //Häuser erstellen
            for (int _Spielernummer = 0; _Spielernummer < 4; _Spielernummer++)
            {
                Haus[] hausarr = new Haus[5];
                häuserpool[_Spielernummer] = hausarr;
            }

            for (int _Spielernummer = 0; _Spielernummer < 4; _Spielernummer++)
			{
                for (int _Figurennummer = 0; _Figurennummer < 5; _Figurennummer++)
			    {
                    Haus haus = new Haus(_Spielernummer, _Figurennummer);
                    häuserpool[_Spielernummer][_Figurennummer] = haus;
			    }                
			}

            //Barrikaden erstellen
            for (int _Barrikadennummer = 0; _Barrikadennummer < 11; _Barrikadennummer++)
            {
                Barrikade barrikade = new Barrikade(_Barrikadennummer);
                barrikadenpool[_Barrikadennummer] = barrikade;
            }

            //Let's get ready to rumble...
            WerIstDran = 0;
        }



        //========//
        //Methoden//
        //========//

        /// <summary>
        /// Figur 1 schlägt Figur 2. Figur 1 zieht auf den Platz von Figur 2 und Figur 2 kommt in ihr Haus zurück.
        /// </summary>
        /// <param name="figur1">Schlagende Figur</param>
        /// <param name="figur2">Zu schlagende Figur</param>
        public void Schlagen(Figur figur1, Figur figur2)
        {
            felderpool[figur1.X][figur1.Y].IstBelegt = false;
            figurenpool[figur1.Spielernummer][figur1.Figurennummer].Position = figur2.Position;

            felderpool[figur1.X][figur1.Y].WirdBelegt(figur1);
            häuserpool[figur2.Spielernummer][figur2.Figurennummer].IstBelegt = true;

            figurenpool[figur2.Spielernummer][figur2.Figurennummer].Geschlagen();
        }

        /// <summary>
        /// Eine Figur kommt am Schluss ihres Zuges auf ein Feld auf dem eine Barrikade steht. Diese Methode 
        /// setzt die Figur auf dieses Feld und gibt dem Spieler die Barrikade um sie zu versetzen.
        /// </summary>
        /// <param name="figur">Figur, die auf das Feld mit der Barrikade kommt.</param>
        /// <param name="barrikade">Barrikade, die auf diesem Feld steht.</param>
        public void NehmeBarrikade(Figur figur, Barrikade barrikade)
        {
            LetztesFeld = figur.Position;
            felderpool[figur.X][figur.Y].IstBelegt = false;
            figurenpool[figur.Spielernummer][figur.Figurennummer].Position = barrikade.Position;
            felderpool[barrikade.X][barrikade.Y].IstBlockiert = false;
            felderpool[figur.X][figur.Y].WirdBelegt(figur);
            
            spielerpool[figur.Spielernummer].Barrikadennummer = barrikade.Barrikadennummer;
            spielerpool[figur.Spielernummer].HatBarrikade = true;
        }

        /// <summary>
        /// Eine bereits vom Spieler aufgenommene Barrikade soll auf ein anderes Feld gesetzt werden. 
        /// Anschließend wird der Zug beendet, indem die Eigenschaft WerIstDran um eins erhöht wird.
        /// ACHTUNG: Dass die Barrikade nicht in die unterste Reihe darf, muss vorher abgefangen werden!!!
        /// </summary>
        /// <param name="barrikade">Nummer der Barrikade: 0: Barrikade 1 ... 10: Barrikade 11</param>
        /// <param name="feld">Auf welches Feld soll die Barrikade gesetzt werden?</param>        
        public void VersetzeBarrikade(Barrikade barrikade, Feld feld)
        {
            barrikadenpool[barrikade.Barrikadennummer].Position = feld.Koordinate;
            felderpool[feld.X][feld.Y].WirdBlockiert(barrikade);

            spielerpool[WerIstDran].HatBarrikade = false;
        }

        /// <summary>
        /// Diese Methode soll aufgerufen werden, wenn der Benutzer seinen Zug macht und eine seiner Spielfiguren auf ein Nachbarfeld zieht. 
        /// </summary>
        /// <param name="figur">Welche Figur wird bewegt?</param>
        /// <param name="zielfeld">Wohin wird die Figur bewegt?</param>
        public void Move(Figur figur, Feld zielfeld)
        {
            if (NochZuGehen == Augenzahl)
            {
                x_vorZug = figurenpool[WerIstDran][figur.Figurennummer].X;
                y_vorZug = figurenpool[WerIstDran][figur.Figurennummer].Y;
                spielernummer_vorZug = werIstDran;
                figurnummer_vorZug = figur.Figurennummer;
                LetztesFeld = figur.Position;
                ausgewählt = new Figurennummerierung(figur.Spielernummer, figur.Figurennummer);

                Ziehen(zielfeld, figur);
                return;
            }

            if (NochZuGehen < Augenzahl)
            {
                Ziehen(zielfeld, figur);
                return;
            }
        }

        private void Ziehen(Feld zielfeld, Figur figur)
        {
            //Prüfe, ob ein Zug auf das gewählte Feld möglich ist
            if (zielfeld.ExistiertDasFeld == false)
            {
                return;     //Zug nicht möglich
            }

            if (figur.Figurennummer != ausgewählt.FigurenNummer)
            {
                return;
            }

            //Die Figur knallt gegen eine Barrikade
            if (zielfeld.IstBlockiert == true && NochZuGehen != 1)
            {
                return;     //Zug nicht möglich
            }

            //Die Figur will vor einem Haus parken
            if (NochZuGehen == 1 && (zielfeld.X == 2 || zielfeld.X == 6 || zielfeld.X == 10 || zielfeld.X == 14) && zielfeld.Y == 0)
            {
                return;     //Figur darf nicht vor einem Haus geparkt werden.
            }

            //Die Figur will "hin- und zurückspringen"
            if (zielfeld.X == LetztesFeld.X && zielfeld.Y == LetztesFeld.Y)
            {
                return;
            }

            //Der Spieler will seine eigene Figur schlagen
            if (NochZuGehen == 1 && zielfeld.Spielernummer == figur.Spielernummer && zielfeld.IstBelegt == true)
            {
                return;     //Zug nicht möglich
            }

            //Nur wenn sich das Zielfeld direkt rechts, links, über oder unter dem alten Feld der Figur befindet, ist ein Verschieben möglich.
            if ((zielfeld.X + 1 == figur.X && zielfeld.Y == figur.Y) || (zielfeld.X - 1 == figur.X && zielfeld.Y == figur.Y)
                || (zielfeld.Y + 1 == figur.Y && zielfeld.X == figur.X) || (zielfeld.Y - 1 == figur.Y && zielfeld.X == figur.X))
            {
                //SIEG!!!
                if (NochZuGehen == 1 && zielfeld.X == 8 && zielfeld.Y == 13)
                {
                    //Figur erreicht das Ziel und gewinnt für diesen Spieler das Match.
                    felderpool[figur.X][figur.Y].IstBelegt = false;
                    felderpool[zielfeld.X][zielfeld.Y].WirdBelegt(figur);
                    figurenpool[figur.Spielernummer][figur.Figurennummer].Position = zielfeld.Koordinate;

                    ende = true;
                    BeendeSpiel(figur);
                    return;
                }

                //Spieler nimmt Barrikade auf
                if (zielfeld.IstBlockiert == true && NochZuGehen == 1)
                {
                    if (wurdeFigurÜbersprungen == true)
                    {
                        wurdeFigurÜbersprungen = false;
                        felderpool[übersprungen_position.X][übersprungen_position.Y].Spielernummer = übersprungen_nummerierung.SpielerNummer;
                        felderpool[übersprungen_position.X][übersprungen_position.Y].Figurnummer = übersprungen_nummerierung.FigurenNummer;
                        figurenpool[übersprungen_nummerierung.SpielerNummer][übersprungen_nummerierung.FigurenNummer].Position = übersprungen_position;
                        figurenpool[übersprungen_nummerierung.SpielerNummer][übersprungen_nummerierung.FigurenNummer].Im_Haus = false;
                        felderpool[übersprungen_position.X][übersprungen_position.Y].IstBelegt = true;
                    }

                    NehmeBarrikade(figur, barrikadenpool[zielfeld.Barrikadennummer]);
                    
                    NochZuGehen--;
                    return;
                }

                //Spielfigur schlägt eine gegnerische Figur
                if (NochZuGehen == 1 && zielfeld.Spielernummer != figur.Spielernummer && zielfeld.IstBelegt == true)
                {
                    LetztesFeld = figur.Position;
                    Schlagen(figur, figurenpool[zielfeld.Spielernummer][zielfeld.Figurnummer]);

                    if (wurdeFigurÜbersprungen == true)
                    {
                        wurdeFigurÜbersprungen = false;
                        felderpool[übersprungen_position.X][übersprungen_position.Y].Spielernummer = übersprungen_nummerierung.SpielerNummer;
                        felderpool[übersprungen_position.X][übersprungen_position.Y].Figurnummer = übersprungen_nummerierung.FigurenNummer;
                        figurenpool[übersprungen_nummerierung.SpielerNummer][übersprungen_nummerierung.FigurenNummer].Position = übersprungen_position;
                        figurenpool[übersprungen_nummerierung.SpielerNummer][übersprungen_nummerierung.FigurenNummer].Im_Haus = false;
                        felderpool[übersprungen_position.X][übersprungen_position.Y].IstBelegt = true;
                    }
                    NochZuGehen--;
                    return;
                }

                //Spielfigur rückt ganz normal vor
                if (zielfeld.IstBelegt == true && NochZuGehen > 1)
                {
                    if (wurdeFigurÜbersprungen == true)
                    {
                        //Vorher wurde schon einmal eine Figur übersprungen
                        felderpool[übersprungen_position.X][übersprungen_position.Y].Spielernummer = übersprungen_nummerierung.SpielerNummer;
                        felderpool[übersprungen_position.X][übersprungen_position.Y].Figurnummer = übersprungen_nummerierung.FigurenNummer;
                        figurenpool[übersprungen_nummerierung.SpielerNummer][übersprungen_nummerierung.FigurenNummer].Position = übersprungen_position;
                        figurenpool[übersprungen_nummerierung.SpielerNummer][übersprungen_nummerierung.FigurenNummer].Im_Haus = false;
                        felderpool[übersprungen_position.X][übersprungen_position.Y].IstBelegt = true;

                        übersprungen_nummerierung = new Figurennummerierung(zielfeld.Spielernummer, zielfeld.Figurnummer);
                        übersprungen_position = new Feldposition(zielfeld.X, zielfeld.Y);

                        LetztesFeld = figur.Position;
                        felderpool[zielfeld.X][zielfeld.Y].WirdBelegt(figur);
                        figurenpool[figur.Spielernummer][figur.Figurennummer].Position = zielfeld.Koordinate;

                        wurdeFigurÜbersprungen = true;
                        NochZuGehen--;
                        letztes_x = zielfeld.X;
                        letztes_y = zielfeld.Y;
                        return;
                    }

                    //Die Figur auf dem Zielfeld wird übersprungen.
                    übersprungen_nummerierung = new Figurennummerierung(zielfeld.Spielernummer, zielfeld.Figurnummer);
                    übersprungen_position = new Feldposition(zielfeld.X, zielfeld.Y);

                    LetztesFeld = figur.Position;
                    felderpool[figur.X][figur.Y].IstBelegt = false;
                    felderpool[zielfeld.X][zielfeld.Y].WirdBelegt(figur);
                    figurenpool[figur.Spielernummer][figur.Figurennummer].Position = zielfeld.Koordinate;

                    NochZuGehen--;
                    wurdeFigurÜbersprungen = true;
                    letztes_x = zielfeld.X;
                    letztes_y = zielfeld.Y;
                    return;
                }

                LetztesFeld = figur.Position;
                felderpool[figur.X][figur.Y].IstBelegt = false;
                felderpool[zielfeld.X][zielfeld.Y].WirdBelegt(figur);
                figurenpool[figur.Spielernummer][figur.Figurennummer].Position = zielfeld.Koordinate;

                if (wurdeFigurÜbersprungen == true)
                {
                    wurdeFigurÜbersprungen = false;
                    felderpool[übersprungen_position.X][übersprungen_position.Y].Spielernummer = übersprungen_nummerierung.SpielerNummer;
                    felderpool[übersprungen_position.X][übersprungen_position.Y].Figurnummer = übersprungen_nummerierung.FigurenNummer;
                    figurenpool[übersprungen_nummerierung.SpielerNummer][übersprungen_nummerierung.FigurenNummer].Position = übersprungen_position;
                    figurenpool[übersprungen_nummerierung.SpielerNummer][übersprungen_nummerierung.FigurenNummer].Im_Haus = false;
                    felderpool[übersprungen_position.X][übersprungen_position.Y].IstBelegt = true;
                }

                NochZuGehen--;
                letztes_x = zielfeld.X;
                letztes_y = zielfeld.Y;
                return;
            }

            //Dies war der letzte Zug
            if (NochZuGehen == 0)
            {
                NochZuGehen--;
                return;     //Zug fertig
            }
        }

        public void GeheAusDemHaus(Figur figur)
        {
            ZieheMitNeuerFigur = true;

            häuserpool[figur.Spielernummer][figur.Figurennummer].IstBelegt = false;
            felderpool[figur.X][figur.Y].IstBelegt = true;
            felderpool[figur.X][figur.Y].AktuelleBelegung = figur.Nummerierung;
            figurenpool[figur.Spielernummer][figur.Figurennummer].Im_Haus = false;
        }
        
        /// <summary>
        /// Diese Methode soll aufgerufen werden, wenn eine Spielfigur das Ziel erreicht und damit das Spiel gewinnt.
        /// </summary>
        /// <param name="figur">Welche Figur erreicht das Ziel?</param>
        private void BeendeSpiel(Figur figur)
        {
            Beende_Form beendeForm = new Beende_Form(spielerpool[figur.Spielernummer]);
            beendeForm.Show();
        }
    }
}