﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Threading;



namespace Projekt
{
    
    public partial class Form1 : Form
    {

        public Form1()
        {
            InitializeComponent();
            DefaultScreen();
        }

        string pfad = string.Empty; //speichert den gerade aktiven Pfad
        Death tod = new Death(); 
        LevelEditor levelEditor1 = new LevelEditor();
        SUBMENU submenu = SUBMENU.start; //hier steht, welches Submenu gerade aktiv ist
        Hilfe hilfe = new Hilfe();
        NeuStory story = new NeuStory();

        public Hilfe GetHilfe()
        {
            return hilfe;
        }

       

        public Death Tod
        {
            get { return tod; }
            set { tod = value; }
        }

        public MenuStrip Menustrip1
        {
            get { return menuStrip1; }
            set {menuStrip1=value;}
        }

       
        
        
       

       //true, falls der Leveleditor geöffnet wurde
        bool leveledit=false;

       /// <summary>
       /// gibt and, ob der Leveleditor geöffnet wurde
       /// </summary>
        public bool Leveledit
       {
           get { return leveledit; }
           set { leveledit = value; }
       }

        bool storyedit=false;

        /// <summary>
        /// gibt and, ob der Storyeditor geöffnet wurde
        /// </summary>
        public bool Storyedit
        {
            get { return storyedit; }
            set { storyedit = value; }
        }


        /// <summary>
        /// stellt den Defaultscreen wieder her (von Programmstart)
        /// </summary>
        public void DefaultScreen()
        {
            submenu=SUBMENU.start;
            heroStatus1.Visible = false;
            heldSteuerung1.Visible = false;
            spielFenster1.Visible = false;
            SetText(string.Empty);
            DisableSpiel("&Speichern");
            DisableSpiel("Speichern &unter");
            DisableSpiel("close current Window");
            this.Controls.Remove(levelEditor1);
            this.Controls.Remove(tod);
            this.Controls.Remove(heldErstellen1);
            this.Controls.Remove(neuMonster1);
            neuesSpielStartenToolStripMenuItem.Enabled = false;
        }

        /// <summary>
        /// öffnet den Gamescreen
        /// </summary>
        public void GameScreen()
        {
            heldSteuerung1.Visible = true;
            spielFenster1.Visible = true;
            heroStatus1.Visible = true;
            submenu=SUBMENU.spiel;
            menuStrip1.Items[3].Enabled = false;
            DisableSpiel("&Neuen Helden erstellen");
            DisableSpiel("neues Spiel starten");
            EnableSpiel("close current Window");
            
        }

        
        /// <summary>
        /// öffnet den Screen der 'Erstellen' Optionen
        /// </summary>
        /// <param name="cont">Übergibt Kontrollstruktur</param>
        public void ErstellenScreen(System.Windows.Forms.Control cont)
        {

            heldSteuerung1.Visible = false;
            spielFenster1.Visible = false;
            heroStatus1.Visible = false;
            this.Controls.Add(cont);
            EnableSpiel("close current Window");
        }

        private void MenuDisable()
        {

            menuStrip1.Items[0].Enabled = false;
            menuStrip1.Items[1].Enabled = false;
            menuStrip1.Items[3].Enabled = false;


        }

        public void MenuEnable()
        {
            menuStrip1.Items[0].Enabled = true;
            menuStrip1.Items[1].Enabled = true;
            menuStrip1.Items[3].Enabled = true;
        }


        //-------------------------------------------------------------------------
        //--------------------------------------------------------------------------
        //------------------------- Clickevents ----------------------------------
        //----------------------------------------------------------------------
        //-----------------------------------------------------------------------

        
        /// <summary>
        /// zuständig für Speichern unter Menu
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void speichernunterToolStripMenuItem_Click(object sender, EventArgs e)
        {
            
            pfad=FileTransfer.ChooseFile(speichernunterToolStripMenuItem.Text.ToString());
            if (pfad == String.Empty)
            {
                MessageBox.Show("Abbruch");
            }
            else
            StaticCollect.Held.HeroQuickSave(pfad);
            submenu=SUBMENU.spiel;
         }

        /// <summary>
        /// zuständig für Speichern Menu
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void speichernToolStripMenuItem_Click(object sender, EventArgs e)
        {
            StaticCollect.Held.HeroQuickSave(StaticCollect.Held.Name);
        }

        /// <summary>
        /// zusändig für beenden Menu
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void beendenToolStripMenuItem_Click(object sender, EventArgs e)
        {

            if (MessageBox.Show("wollen Sie beenden?", "beenden", MessageBoxButtons.OKCancel, MessageBoxIcon.Question) == DialogResult.OK)
                Application.Exit();
         
        }

        /// <summary>
        /// zuständig für Öffnen Menü
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void öffnenToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string dateiname=FileTransfer.ChooseFile("Laden");
            if (dateiname == String.Empty)
            {
                MessageBox.Show("Abbruch");
            }
            else
            {
                StaticCollect.Held = FileTransfer.QuickLoad<Hero>(dateiname);
                GameScreen();
                StaticCollect.LoadMesh();
                heroStatus1.HeroStatusUpdate();
                GrafikUpdate(string.Empty);
            }
           submenu=SUBMENU.spiel;
            
        }

        private void optionenToolStripMenuItem_Click(object sender, EventArgs e)
        {
            submenu = SUBMENU.optionen;
            MessageBox.Show("fehlt noch");
        }


        /// <summary>
        /// zusändig für Info Menü
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void infoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            MessageBox.Show("hier kommen copyright Sachen rein.","Copyright",MessageBoxButtons.OK, MessageBoxIcon.Information);
        }

        /// <summary>
        /// zuständig um einen neuen Helden anzulegen
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void neuToolStripMenuItem_Click(object sender, EventArgs e)
        {
            MenuDisable();
            submenu=SUBMENU.neuheld;
            heldErstellen1.Dock = DockStyle.Fill;
            ErstellenScreen(heldErstellen1);
           
        }
        
        
        /// <summary>
        /// zuständig um ein neues Monster anzulegen
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void neuesMonsterToolStripMenuItem_Click(object sender, EventArgs e)
        {

            MenuDisable();
            submenu = SUBMENU.neuesmonster;
            neuMonster1.Dock = DockStyle.Fill;
            ErstellenScreen(neuMonster1);
        }

        
        /// <summary>
        /// zuständig um ein neues Level zu generieren
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void levelToolStripMenuItem_Click(object sender, EventArgs e)
        {
           
            GameScreen();
            MenuDisable();
            heroStatus1.Visible = false;
            Leveledit = true;
            submenu = SUBMENU.level;
            levelEditor1.Dock = DockStyle.Fill;
            this.Controls.Add(levelEditor1);
            if (StaticCollect.MeshExists())
            {
                StaticCollect.LoadMesh();
                GrafikUpdate(string.Empty);
            }
            LevelEditorUpdate();    
        }

        public void SetText(string str)
        {
            label_text.Text = str;           
        }


        
        /// <summary>
        /// schließt momentanes Spiel
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void closeCurrentGameToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Leveledit = false;
            EnableSpiel("&Neuen Helden erstellen");
            EnableSpiel("neues Spiel starten");
            menuStrip1.Items[3].Enabled = true;
            MenustripControlEnable(closeCurrentGameToolStripMenuItem.Text, true);
            DefaultScreen();
             
        }

        /// <summary>
        /// update des Grafik Windows
        /// </summary>
        /// <param name="name"></param>
        public void GrafikUpdate(string name)
        {
            spielFenster1.GrafikUpdate(name);

        }

        public void HeroStatusUpdate()
        {
            heroStatus1.HeroStatusUpdate();
        }

        /// <summary>
        /// update des Leveleditors
        /// </summary>
        public void LevelEditorUpdate()
        {
            levelEditor1.LevelEditorUpdate();
        }


        

        

        /// <summary>
        /// startet neues Spiel
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void neuesSpielStartenToolStripMenuItem_Click(object sender, EventArgs e)
        {
            
            submenu=SUBMENU.spiel;
            MenustripControlEnable(closeCurrentGameToolStripMenuItem.Text, false);
            speichernToolStripMenuItem.Enabled = true;
            speichernunterToolStripMenuItem.Enabled = true;
            öffnenToolStripMenuItem.Enabled = true;
            GameScreen();
            StaticCollect.LoadMesh();
            heroStatus1.HeroStatusUpdate();
            GrafikUpdate(StaticCollect.Currentmesh.Monster.Avatarfile);
        }

        public void Death()
        {
            this.DefaultScreen();
            this.Controls.Add(tod);
            MessageBox.Show("Du bist Tod");
            this.Controls.Remove(tod);
        }

        /// <summary>
        /// öffnet die Hilfe
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void inhaltToolStripMenuItem_Click(object sender, EventArgs e)
        {
            hilfe.ClearBox();
            switch (submenu)
            {

                case SUBMENU.start:
                    {
                       hilfe.GetMainHelp(); break;
                    }

                case SUBMENU.spiel:
                        {
                            hilfe.GetGameHilfe(); break;
                        }
                case SUBMENU.optionen:
                        {
                            hilfe.GetOptionHilfe(); break;
                        }
                case SUBMENU.neuheld:
                        {
                            hilfe.GetHeldHilfe(); break;
                        }
                case SUBMENU.neuesmonster:
                        {
                            hilfe.GetMonsterHilfe(); break;
                        }
                case SUBMENU.level:
                        {
                            hilfe.GetLevelHilfe(); break;
                        }

                case SUBMENU.story:
                        {
                            hilfe.GetStoryHilfe(); break;
                        }

                case SUBMENU.item:
                        {
                            hilfe.GetItemHilfe(); break;
                        }


                default:
                    {
                        hilfe.AddTitle("Fehler"); break;
                    }
            }
           
            hilfe.ShowDialog();
            
        }

        private void storyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            submenu = SUBMENU.story;

            MenuDisable();
            heroStatus1.Visible = false;
            Storyedit = true;
            submenu = SUBMENU.level;
            story.Dock = DockStyle.Fill;
            ErstellenScreen(story);  
  
        }

        private void itemToolStripMenuItem_Click(object sender, EventArgs e)
        {
            MenuDisable();
            submenu = SUBMENU.item;
            NeuItem item = new NeuItem();
            item.Dock = DockStyle.Fill;
            ErstellenScreen(item);

        }


        


        //----------------------------------------------------------------------------------------------
        //---------------------------------------------------------------------------------------------
        // diese Sachen stehen in der Hilfe, wenn sie aufgerufen wird, nur Hauptfenster aktiviert
        //----------------------------------------------------------------------------------------------
        //----------------------------------------------------------------------------------------------

        enum SUBMENU //submenu für Hilfe
        {
            start,
            spiel,
            neuheld,
            optionen,
            level,
            neuesmonster,
            story,
            item
        };
        
        
       
  
        
        //-----------------------------------------------------------------------------------------------------
        //---------------------------------------------------------------------------------------------------
        //ab hier kommen nur Sachen die den MenuBar enablen, disablen, auslesen, nicht wichtig für Spielverlauf
        //--------------------------------------------------------------------------------------------------
        //--------------------------------------------------------------------------------------------------
        
        
        /// <summary>
        /// enabled oder disabled Sachen im Menustrip
        /// </summary>
        /// <param name="item"></param>
        /// <param name="help"></param>
        public void MenustripControlEnable(string item, bool help) //(false) setzt alles in menubar auf disabled, ausser item, (true) oder enabled alles außer item
        {
            foreach (ToolStripMenuItem mainMenu in menuStrip1.Items)
            {
                // help always enabled...
                if (mainMenu.Text ==hilfeToolStripMenuItem.Text)
                    continue;

                
                // navigate through each submenu
                foreach (ToolStripItem subMenu in mainMenu.DropDownItems)
                {
                    if (subMenu.Text == beendenToolStripMenuItem.Text)
                        continue;

                    if (help == true)
                    {
                        subMenu.Enabled = true;
                        if (subMenu.Text == item)
                            subMenu.Enabled = false;
                    }
                    else
                    {
                        if (!(subMenu.Text == @item))
                            subMenu.Enabled = false;
                    }
                    
                }
            }
        }

        /// <summary>
        /// disabled einen SubMenubutton
        /// </summary>
        /// <param name="str"></param>
        public void DisableSpiel(string str)
        {
            ToolStripMenuItem firstmainMenu = (ToolStripMenuItem)menuStrip1.Items[0];
            foreach (ToolStripItem subMenu in firstmainMenu.DropDownItems)
            {
                if (subMenu.Text == str)
                {
                    subMenu.Enabled = false;
                }
            }
        }

        /// <summary>
        /// enabled einen Submenubutton
        /// </summary>
        /// <param name="str"></param>
        public void EnableSpiel(string str)
        {
            ToolStripMenuItem firstmainMenu = (ToolStripMenuItem)menuStrip1.Items[0];
            foreach (ToolStripItem subMenu in firstmainMenu.DropDownItems)
            {
                if (subMenu.Text == str)
                {
                    subMenu.Enabled = true;
                }
            }
        }

        

        
       

        

        

        
    }
}
