﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Projekt
{
    [Serializable]
    public class Item
    {
        public Item()
        {
            attributes = new int[this.GetAttributesNames().Length];
        }
        
        string name;

    
     public string Name
    {
        get { return name; }
        set { name = value; }
    }


     int id;

     public int Id
     {
         get { return id; }
         set { id = value; }
     }
        
        string gender;

    public string Gender
    {
        get { return gender; }
        set { gender = value; }
    }

    

    public string[] GetAllGenderNames() //liefert alle Gender 
    {
        return Enum.GetNames(typeof(GENDER));

    }
        
        
       public enum GENDER
        {
            Schild,
            Schwert,
            Helm,
            Platte,
            Hose,
            Schuhe,
            Amulett
        };

        string avatarfile;

        public string Avatarfile
        {
            get { return avatarfile; }
            set { avatarfile = value; }
        }  

       int[] attributes;

        public int[] Attributes
        {
            get { return attributes; }
            set { attributes = value; }
        }
        public void AttributeSpecialSet(int atr, int val) //setzen eines Attributes
        {
            attributes[atr] = val;
        }

        public string[] GetAttributesNames() //liefert alle Attribute 
        {
            return Enum.GetNames(typeof(ATTRIBUTES));

        }
        
        public enum ATTRIBUTES
        {
            might,
            dexterity,
            reaction,
            armor
        };

        //-------------------------------------------------------------
        //-------------------- defaultitem ----------------------------
        //--------------------------------------------------------------
        public Item DefaultItem()
        {
            this.Name = "nichts";
            foreach(ATTRIBUTES attr in Enum.GetValues(typeof(ATTRIBUTES)))
            {
                attributes[(int)attr] = 0;
            }
            return this;
        }

        //---------------------------------------------------------------------------
        //------------------------------- Fileoperationen ------------------------------
        //--------------------------------------------------------------------------------
        public void ItemQuickSave(string dateiname) //speichert Instanz Hero als xml
        {
            FileTransfer.QuickSave<Item>(this, Application.StartupPath + "\\XmlFiles\\Items\\" + dateiname);
        }

        public Item ItemQuickLoad(string dateiname) //laedt xml Datei als Instanz Hero
        {
            return FileTransfer.QuickLoad<Item>(Application.StartupPath + "\\XmlFiles\\Items\\" + dateiname);
        }

        public string[] GetAllItemNames()
        {

            return FileTransfer.GetAllFileNames(Application.StartupPath + "\\XmlFiles\\Items\\");
        }
        
    }
}
