﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Projekt
{
    public partial class NeuStory : UserControl
    {
        Story story = new Story();
        Monster monster = new Monster();
        Item item = new Item();
        Hero held = new Hero();
        public NeuStory()
        {
            InitializeComponent();
            foreach (string str in monster.GetAllMonsterNames())
            {
                listBox_monster.Items.Add(str);
            }

            foreach (string str in item.GetAllItemNames())
            {
                listBox_drop.Items.Add(str);
            }
            update();
        }

        public void update()
        {
            if (story.StoryExists(held.CoordinateX,held.CoordinateY))
            {
                story = story.LoadStory(held.CoordinateX, held.CoordinateY);
            }
            else
            story = new Story();
            label_mem.Text = story.Listmonster.Count.ToString();
            listBox_drop.ClearSelected();
            listBox_monster.ClearSelected();
            if (StaticCollect.Currentmesh.MeshExists(held.CoordinateX, held.CoordinateY))
            {
                StaticCollect.Currentmesh = StaticCollect.Currentmesh.MeshQuickLoad(held.CoordinateX, held.CoordinateY);
                
            }

            label_pos.Text = "Position: X Koordinate: " + held.CoordinateX.ToString() + " Y Koordinate: " + held.CoordinateY.ToString();
            spielFenster1.GrafikUpdate(string.Empty);

        }

        private void button_ok_Click(object sender, EventArgs e)
        {
            story.Monster(monster, item);
            label_mem.Text = story.Listmonster.Count.ToString();

        }

        private void listBox_monster_SelectedIndexChanged(object sender, EventArgs e)
        {
            if(!(listBox_monster.SelectedIndex==-1))
            monster = monster.MonsterQuickLoad(listBox_monster.SelectedItem.ToString());
        }

        private void listBox_drop_SelectedIndexChanged(object sender, EventArgs e)
        {
            if(!(listBox_drop.SelectedIndex==-1))
            item = item.ItemQuickLoad(listBox_drop.SelectedItem.ToString());
        }

        private void button_anlegen_Click(object sender, EventArgs e)
        {
            story.SaveStory(held.CoordinateX,held.CoordinateY);
        }

        

        private void button_vor_Click(object sender, EventArgs e)
        {
            if (StaticCollect.Currentmesh.Wall[(int)StaticCollect.EXPOSITION.north] && !StaticCollect.Currentmesh.Wall[(int)StaticCollect.EXPOSITION.doornorth])
            {
                MessageBox.Show("Wand");
            }

            else
            {
                if (StaticCollect.Currentmesh.MeshExists(held.CoordinateX, held.CoordinateY + 1))
                {
                    held.CoordinateY++;
                    update();
                }
                else
                {
                    MessageBox.Show("dieses Mesh existiert noch nicht");
                }

            }
        }

        private void buttonlinks_Click(object sender, EventArgs e)
        {
            if (StaticCollect.Currentmesh.Wall[(int)StaticCollect.EXPOSITION.west])
            {
                MessageBox.Show("Wand");
            }

            else
            {
                held.CoordinateX--;
                update();
            }
        }

        private void button_hinten_Click(object sender, EventArgs e)
        {
            if (StaticCollect.Currentmesh.Wall[(int)StaticCollect.EXPOSITION.south]&&!StaticCollect.Currentmesh.Wall[(int)StaticCollect.EXPOSITION.doorsouth])
            {
                MessageBox.Show("Wand");
            }

            else
            {
                if (StaticCollect.Currentmesh.MeshExists(held.CoordinateX, held.CoordinateY - 1))
                {
                    held.CoordinateY--;
                    update();
                }

                else
                {
                    MessageBox.Show("dieses Mesh existerit noch nicht");
                }
            }
        }

        private void button_rechts_Click(object sender, EventArgs e)
        {
            if (StaticCollect.Currentmesh.Wall[(int)StaticCollect.EXPOSITION.east])
            {
                MessageBox.Show("Wand");
            }

            else
            {
                held.CoordinateX++;
                update();
            }
        }

        private void button_close_Click(object sender, EventArgs e)
        {
            close();
        }

        private void close()
        {

            (this.Parent as Form1).MenuEnable();
            (this.Parent as Form).Controls.Remove(this);
        }


    }
}
