﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Projekt
{
    public partial class Hilfe : Form
    {
        public Hilfe()
        {
            InitializeComponent();
        }
        
       
        //---------------------------------------------------------------------
        //----------- Funktionen, die für den Text verantwortlich sind ---------
        //---------------------------------------------------------------------
        public void AddString(string str)
        {
            richTextBox1.AppendText(str);
        }

        public void AddLine(string str)
        {
            richTextBox1.AppendText("\n"+str);
        }

        public void AddTitle(string str)
        {
           int pos = richTextBox1.TextLength;
           if (pos == 0)
               richTextBox1.AppendText(str + "\n");
           else
           {
               richTextBox1.AppendText("\n" + str + "\n");
               pos++;
           }
           richTextBox1.Select(pos, str.Length);
           richTextBox1.SelectionColor = Color.Red;
           richTextBox1.DeselectAll();
            
        }

        public void ClearBox()
        {
            richTextBox1.Text = string.Empty;
        }

        public void SetText(List<string> str1, List<string> str2)
        {
            for (int i = 0; i < str1.Count; i++)
            {
                this.AddTitle(str1[i] + ":");
                this.AddLine(str2[i]);
                this.AddLine("\n");
            }
            

        }


        
       
          
       

        private void button1_Click(object sender, EventArgs e)
        {
            this.Close();
        }
       
        //----------------------------------------------------------------------
        //---------------------------------------------------------------------
        //------------------ Inhalt der Hilfe ---------------------------------
        //----------------------------------------------------------------------
        //-------------------------------------------------------------------


        //-----------------------------------------------------------------
        //------------------ HauptFenster ----------------------------------
        //-------------------------------------------------------------------
        public enum MENU
        {
            spiel,
            extras,
            hilfe,
            erstellen
        };





        public enum SPIELSUBMENU
        {
            titel,
            abstractspiel,
            neuheld,
            oeffnen,
            speichern,
            speichernunter,
            beenden,
            closecurrentwindow,
            neuesspiel
        };

        public enum EXTRASUBMENU
        {
            titel,
            abstractextras,
            optionen,
        };

        public enum HILFESUBMENU
        {
            titel,
            abstracthilfe,
            hilfe,
            info
        };

        public enum ERSTELLENSUBMENU
        {
            titel,
            abstracterstellen,
            level,
            neuesmonster,
            story,
            item

        };

        List<string> spielhilfestring = new List<string>(Enum.GetNames(typeof(SPIELSUBMENU)).Length);

        public List<string> GetSpielHilfestring()
        {

            spielhilfestring.Insert((int)SPIELSUBMENU.titel, "Spiel:");
            spielhilfestring.Insert((int)SPIELSUBMENU.abstractspiel, "Dies ist verantwortlich für den Spielverlauf");
            spielhilfestring.Insert((int)SPIELSUBMENU.neuheld, "Neuen Helden: hier kann man einen neuen Helden erstellen");
            spielhilfestring.Insert((int)SPIELSUBMENU.oeffnen, "öffnen: hier kann man ein vorhandenes Spiel öffnen");
            spielhilfestring.Insert((int)SPIELSUBMENU.speichern, "speichern: schnell Speichern der Spielstandes");
            spielhilfestring.Insert((int)SPIELSUBMENU.speichernunter, "speichern unter: speichert den Spielstand in eine Datei");
            spielhilfestring.Insert((int)SPIELSUBMENU.beenden, "beenden: beendet das Spiel");
            spielhilfestring.Insert((int)SPIELSUBMENU.closecurrentwindow, "closecurrentwindow: schließt das momentan geöffnete Fenster ");
            spielhilfestring.Insert((int)SPIELSUBMENU.neuesspiel, "neues Spiel: startet ein neues Spiel");
            return spielhilfestring;
        }

        List<string> extrashilfestring = new List<string>(Enum.GetNames(typeof(EXTRASUBMENU)).Length);

        public List<string> GetExtrasHilfestring()
        {
            extrashilfestring.Insert((int)EXTRASUBMENU.titel, "Extras:");
            extrashilfestring.Insert((int)EXTRASUBMENU.abstractextras, "Dies ist verantwortlich für spezielle Optionen");
            extrashilfestring.Insert((int)EXTRASUBMENU.optionen, "optionen: öffnet das Optionsmenu (noch nicht vorhanden)");
            return extrashilfestring;
        }

        List<string> hilfehilfestring = new List<string>(Enum.GetNames(typeof(HILFESUBMENU)).Length);
        public List<string> GetHilfeHilfestring()
        {
            hilfehilfestring.Insert((int)HILFESUBMENU.titel, "Hilfe:");
            hilfehilfestring.Insert((int)HILFESUBMENU.abstracthilfe, "Hier findet man informationen");
            hilfehilfestring.Insert((int)HILFESUBMENU.hilfe, "Hilfe: Öffnet die Hilfe für das momentan geöffnete Fenster (interaktiv)");
            hilfehilfestring.Insert((int)HILFESUBMENU.info, "Info..: Copyright Sachen");
            return hilfehilfestring;
        }


        List<string> erstellenhilfestring = new List<string>(Enum.GetNames(typeof(ERSTELLENSUBMENU)).Length);
        public List<string> GetErstellenHilfestring()
        {
            erstellenhilfestring.Insert((int)ERSTELLENSUBMENU.titel, "Erstellen:");
            erstellenhilfestring.Insert((int)ERSTELLENSUBMENU.abstracterstellen, "hier kann man neue Sachen erstellen");
            erstellenhilfestring.Insert((int)ERSTELLENSUBMENU.level, "Level: generiert ein neues Level");
            erstellenhilfestring.Insert((int)ERSTELLENSUBMENU.neuesmonster, "Monster: generiert ein neues Monster");
            erstellenhilfestring.Insert((int)ERSTELLENSUBMENU.story, "Story:: generiert eine neue Story");
            erstellenhilfestring.Insert((int)ERSTELLENSUBMENU.item, "Item: generiert ein neues Item");
            return erstellenhilfestring;
        }

        List<List<string>> hilfestring = new List<List<string>>(Enum.GetNames(typeof(MENU)).Length);
        public List<List<string>> GetHilfestring()
        {
            hilfestring.Insert((int)MENU.spiel, GetSpielHilfestring());
            hilfestring.Insert((int)MENU.extras, GetExtrasHilfestring());
            hilfestring.Insert((int)MENU.hilfe, GetHilfeHilfestring());
            hilfestring.Insert((int)MENU.erstellen, GetErstellenHilfestring());

            return hilfestring;
        }

        public void GetMainHelp()
        {
            GetHilfestring();

            foreach (MENU menu in Enum.GetValues(typeof(MENU)))
            {

                this.AddTitle((hilfestring[(int)menu])[0]);
                this.AddLine((hilfestring[(int)menu])[1]);
                for (int i = 2; i < (hilfestring[(int)menu].Count); i++)
                {
                    this.AddLine(hilfestring[(int)menu][i]);
                }
                this.AddLine("\n");
            }
            hilfestring.Clear();
            hilfehilfestring.Clear();
            spielhilfestring.Clear();
            extrashilfestring.Clear();
            erstellenhilfestring.Clear();

        }

        //-------------------------------------------------------------------
        //--------------------- leveledit Hilfe ------------------------------
        //--------------------------------------------------------------------
        /// <summary>
        /// legt die Hilfe für den Leveleditor fest
        /// </summary>
        public void GetLevelHilfe()
        {
            List<string> list = new List<string>(Enum.GetNames(typeof(LEVELABOUT)).Length);
            list.Insert((int)LEVELABOUT.leveleditor, "hier kann man ein neues Level erstellen, die einzelnen Meshes werden im Ordner 'Rooms' gespeichert");
            list.Insert((int)LEVELABOUT.position, "hier werden die Postitionen der Waende und die Existenz der Tueren festgelegt.\n Falls man noch weitere Objekte hier ansteuern will, kann man diese einfach in der Klasse 'Staticcollect' der enum 'EXPOSITION' hinzufügen. \n Man kann nur eine Wand setzten, falls in einem anliegendem Raum eine Wand vorhanden ist, oder kein anliegender Raum vorhanden ist. (leider muß man noch langsam clicken)");
            list.Insert((int)LEVELABOUT.strings, "Hier werden die Strings gespeichert, die für diesen Raum benötigt werden. \n der String der ausgegeben wird (im Spiel) ist abhängig von der Klasse Memory.");
            list.Insert((int)LEVELABOUT.anlegen, "speichert das aktuell angelgte Mesh als XML in den Ordner 'Rooms'. \n Die Datei hat dan den Namen 'mesh_<XCoord>_<YCoord>.xml' ");
            list.Insert((int)LEVELABOUT.reset, "stellt den Anfangszustand des Fensters wieder her.");
            list.Insert((int)LEVELABOUT.monster, " hier kann man ein Monster in das Mesh einfügen, dieses erscheint mit einer W-Heit von 0.4 wenn man das Mesh betritt. \n Die Auswahl der Monster hängt von den bereits erstellten Monster ab.");
            list.Insert((int)LEVELABOUT.bug, " Probleme sind noch: \n - nachdem man ein neues Mesh erstellt hat, werden die vorhandenen Memories der gespeicherten Helden nicht upgedatet \n - clicked man zu Schnell auf die checkbox der Mauern, umgeht man die überprüfung, ob an angrenzenden Räumen noch Mauern sind ");
            
            List<string> list2 = new List<string>();
            foreach (LEVELABOUT about in Enum.GetValues(typeof(LEVELABOUT)))
            {
                list2.Add(about.ToString() + ":");
            }

            this.SetText(list2, list);

            list2.Clear();
            list.Clear();
        }

        enum LEVELABOUT
        {
            leveleditor,
            position,
            strings,
            anlegen,
            reset,
            monster,
            bug
        };

        //-----------------------------------------------------------------
        //-------------------- monsteredit Hilfe --------------------------
        //-----------------------------------------------------------------

        /// <summary>
        /// legt die Hilfe für Monster Editor  fest
        /// </summary>
        public void GetMonsterHilfe()
        {
            List<string> list = new List<string>(Enum.GetNames(typeof(MONSTERABOUT)).Length);
            list.Insert((int)MONSTERABOUT.monstereditor, "hier kann man ein neues Monster erstellen.");
            list.Insert((int)MONSTERABOUT.name, "hier kann man den Namen des Monsters auswählen.");
            list.Insert((int)MONSTERABOUT.attribute, "Hier lassen sich einzelnen Attribute des Monsters auswaehlen.\n Das Attribut level entscheidet, wieviel Ehrfahrung der Held nach der Schlacht bekommt. \n Das Attribut Gold entscheidet, wieviel Gold der Held nach der Schlacht bekommt. \n Um weitere Attribute hinzuzufügen, reicht es, in der Klasse 'Status' die enum 'ATTRIBUTE' zu erweitern.");
            list.Insert((int)MONSTERABOUT.avatar, " hier kann man einen Avatar des Monsters auswählen. \n Um neue Bilder hinzuzufuegen, reicht es in der Ressource 'Bilder' ein jpg mit dem Namen: 'monster<zahl>' abzulegen");
            list.Insert((int)MONSTERABOUT.anlegen, "speichert das aktuell angelegte Monster als XML in den Ordner 'Monster'. \n Die Datei hat dan den Namen '<name>.xml' ");
            list.Insert((int)MONSTERABOUT.reset, "stellt den Anfangszustand des Fensters wieder her.");
            list.Insert((int)MONSTERABOUT.bug, "nicht entdeckt");

            List<string> list2 = new List<string>();
            foreach (MONSTERABOUT about in Enum.GetValues(typeof(MONSTERABOUT)))
            {
                list2.Add(about.ToString() + ":");
            }

            this.SetText(list2, list);

            list2.Clear();

            list.Clear();
        }

        enum MONSTERABOUT
        {
            monstereditor,
            name,
            attribute,
            avatar,
            anlegen,
            reset,
            bug
        };

        //----------------------------------------------------------------
        //----------------- neuheld Hilfe ------------------------------
        //----------------------------------------------------------------
        /// <summary>
        /// legt die Hilfe für den Held erstellen fest
        /// </summary>
        public void GetHeldHilfe()
        {
            List<string> list = new List<string>(Enum.GetNames(typeof(HEROABOUT)).Length);
            list.Insert((int)HEROABOUT.heroeditor, "hier kann man einen neuen Helden erstellen, die anfänglichen Attribute \n sind im Konstruktor von den Klassen 'Hero' und 'Status' festgelegt. ");
            list.Insert((int)HEROABOUT.name, "hier kann man den Namen des Helden auswählen.");
            list.Insert((int)HEROABOUT.gender, "Hier lassen sich einzelne Gender auswählen.\n Um neue Gender hinzuzufügen, reicht es in der Klasse 'Hero' in dem enum 'GENDER' eine weitere Nummerierung einzufügen ");
            list.Insert((int)HEROABOUT.avatar, " hier kann man einen Avatar abhängig vom Gender auswählen. \n Um neue Bilder hinzuzufuegen, reicht es in der Ressource 'Bilder' ein jpg mit dem Namen: '<Gender><zahl>' abzulegen");
            list.Insert((int)HEROABOUT.anlegen, "speichert den aktuell angelegten Helden als XML in den Ordner 'HEROES'. \n Die Datei hat dan den Namen '<name>.xml' ");
            list.Insert((int)HEROABOUT.reset, "stellt den Anfangszustand des Fensters wieder her.");
            list.Insert((int)HEROABOUT.bug, "nicht entdeckt");

            List<string> list2 = new List<string>();
            foreach (HEROABOUT about in Enum.GetValues(typeof(HEROABOUT)))
            {
                list2.Add(about.ToString() + ":");
            }

            this.SetText(list2, list);

            list2.Clear();
            list.Clear();
        }

        enum HEROABOUT
        {
            heroeditor,
            name,
            gender,
            avatar,
            anlegen,
            reset,
            bug
        };

        //----------------------------------------------------------------
        //----------------- storyeditor Hilfe -----------------------------
        //------------------------------------------------------------------
        public void GetStoryHilfe()
        {
            List<string> list = new List<string>(Enum.GetNames(typeof(HEROABOUT)).Length);
            list.Insert((int)STORYABOUT.storyeditor, "Hier kann man die Story des Spieles festlegen. Leider ist dieser Editor noch nicht ganz fertig, die Stories können nur auf ein Mesh geschrieben werden");
            list.Insert((int)STORYABOUT.monster, "Monster das man bekämpfen kann");
            list.Insert((int)STORYABOUT.item, "item, welches das Monster dropped");
            list.Insert((int)STORYABOUT.bestaetigen, "bestätigt das Monster und den Raum");
            list.Insert((int)STORYABOUT.anlegen, "legt den Raum an und speichert ihn");
            list.Insert((int)STORYABOUT.bug, "nicht bekannt");



            

            List<string> list2 = new List<string>();
            foreach (STORYABOUT about in Enum.GetValues(typeof(STORYABOUT)))
            {
                list2.Add(about.ToString() + ":");
            }

            this.SetText(list2, list);

            list2.Clear();
            list.Clear();
        }

        enum STORYABOUT
        {
            storyeditor,
            monster,
            item,
            bestaetigen,
            anlegen,
            bug
        };
        
        //--------------------------------------------------------------------
        //---------------------- Gameinfo -----------------------------------
        //----------------------------------------------------------------
        public void GetGameHilfe()
        {
            List<string> list = new List<string>(Enum.GetNames(typeof(GAMEABOUT)).Length);
            list.Insert((int)GAMEABOUT.game, "Dies ist ein Rollenspiel, in dem sich ein Held in einem Dungeon bewegt.");
            list.Insert((int)GAMEABOUT.steuerung, "Die Steuerung erfolgt mit den Richtungszeigern (maus) im unteren Bereich des Fensters.");
            list.Insert((int)GAMEABOUT.umsehen, "Der aktuelle string (abhängig von der Memory) wird im Textfenster ausgegeben.");
            list.Insert((int)GAMEABOUT.aktion, "die aktuelle Memory wird ausgeführt.");
            list.Insert((int)GAMEABOUT.heilen, "ein Heiltrank wird verwendet");
            list.Insert((int)GAMEABOUT.bug, "nicht bekannt");
            
            
            List<string> list2 = new List<string>();
            foreach (GAMEABOUT about in Enum.GetValues(typeof(GAMEABOUT)))
            {
                list2.Add(about.ToString() + ":");
            }

            this.SetText(list2, list);

            list2.Clear();

            list.Clear();

            
        }

        enum GAMEABOUT
        {
            game,
            steuerung,
            umsehen,
            aktion,
            heilen,
            bug

        };

        //----------------------------------------------------------------
        //---------------- Optionen Hilfe ----------------------------
        //------------------------------------------------------------
        public void GetOptionHilfe()
        {
            List<string> list = new List<string>(Enum.GetNames(typeof(HEROABOUT)).Length);
            list.Insert((int)OPTIONABOUT.option, "Hier werden die Optionen festgelegt. (leider noch inaktiv)");
            

            List<string> list2 = new List<string>();
            foreach (OPTIONABOUT about in Enum.GetValues(typeof(OPTIONABOUT)))
            {
                list2.Add(about.ToString() + ":");
            }

            this.SetText(list2, list);

            list2.Clear();
            list.Clear();
        }

        enum OPTIONABOUT
        {
            option
        };

        //---------------------------------------------------------------------
        //----------------- itemeditor Hilfe -----------------------------
        //--------------------------------------------------------------
        public void GetItemHilfe()
        {
            List<string> list = new List<string>(Enum.GetNames(typeof(HEROABOUT)).Length);
            list.Insert((int)ITEMABOUT.itemeditor, "hier kann man ein neues 'item erstellen.");
            
            List<string> list2 = new List<string>();
            foreach (ITEMABOUT about in Enum.GetValues(typeof(ITEMABOUT)))
            {
                list2.Add(about.ToString() + ":");
            }

            this.SetText(list2, list);

            list2.Clear();
            list.Clear();

        }

        enum ITEMABOUT
        {
            itemeditor
        }

    }
}
