﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Projekt
{
    public partial class Ausruesten : Form
    {
        Item item = new Item();
        Equipment equip = new Equipment();
        List<Item> itemlist = new List<Item>();
        
        
        public Ausruesten()
        {
            InitializeComponent();
            foreach (string str in item.GetAllGenderNames())
            {
                listBox_gender.Items.Add(str);
            }
            Reset();
            
        }

        private void Reset()
        {
            listBox_Inventar.Visible = false;
            equip = StaticCollect.Held.Equip;
            button_ausruest.Enabled = false;
        }

        

        private void button_close_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void button_ok_Click(object sender, EventArgs e)
        {
            StaticCollect.Held.Equip = equip;
            this.Close();
        }

        private void button_reset_Click(object sender, EventArgs e)
        {
            Reset();
        }

        

       

        private void listBox_gender_SelectedIndexChanged(object sender, EventArgs e)
        {
            listBox_Inventar.Visible = true;
            itemlist = StaticCollect.Held.Inv.GetGenderItems(listBox_gender.SelectedIndex);
            listBox_Inventar.Items.Clear();
            foreach (Item item in itemlist)
            {
                listBox_Inventar.Items.Add(item.Name);
            }
        }

        private void listBox_Inventar_SelectedIndexChanged(object sender, EventArgs e)
        {
            SetWeaponAttributes();
            SetBonusAttributes();
            button_ausruest.Enabled = true;
        }
        
        public void SetWeaponAttributes()
        {
            flowLayoutPanel_attributes.Controls.Clear();
            string[] attributes = item.GetAttributesNames();
            int[] attributesvalue = item.Attributes;
            int zaehler = 0;
            foreach (string str in attributes)
            {
                    Label lbl = new Label();
                    lbl.Text = str + ": " + (attributesvalue[zaehler]);
                    flowLayoutPanel_attributes.Controls.Add(lbl);
                    zaehler++;
            }
        }

        public void SetBonusAttributes()
        {
            flowLayoutPanel_bonus.Controls.Clear();
            int zaehler = 0;
            string[] attributes = item.GetAttributesNames();
            int[] bonusvalue = new int[item.GetAttributesNames().Length];
            foreach (Item.ATTRIBUTES atr in Enum.GetValues(typeof(Item.ATTRIBUTES)))
            {
                foreach (Item.GENDER gend in Enum.GetValues(typeof(Item.GENDER)))
                {
                    bonusvalue[(int)atr] += equip.Equip[(int)gend].Attributes[(int)atr];
                }
            }
            foreach (string str in attributes)
            {
                Label lbl = new Label();
                lbl.Text = str + ": + " + (bonusvalue[zaehler]);
                flowLayoutPanel_bonus.Controls.Add(lbl);
                zaehler++;
            }
            


        }

        public void SetAusgewaehlt()
        {
            flowLayoutPanel_ausgeruestet.Controls.Clear();
            string[] gender = item.GetAllGenderNames();
            string[] auswahl = new string[item.GetAllGenderNames().Length];
            foreach (Item.GENDER gend in Enum.GetValues(typeof(Item.GENDER)))
            {
                Label lbl = new Label();
                lbl.Text = gender[(int)gend] +": " + equip.Equip[(int)gend].Name;
                flowLayoutPanel_ausgeruestet.Controls.Add(lbl);
            }
        }

        private void button_ausruest_Click(object sender, EventArgs e)
        {
            SetAusgewaehlt();
            equip.Equip[listBox_gender.SelectedIndex] = itemlist[listBox_Inventar.SelectedIndex];

        }

        
    }
}
